/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.IotHubResourcesClient;
import com.azure.resourcemanager.iothub.fluent.models.EndpointHealthDataInner;
import com.azure.resourcemanager.iothub.fluent.models.EventHubConsumerGroupInfoInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubDescriptionInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubNameAvailabilityInfoInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubQuotaMetricInfoInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubSkuDescriptionInner;
import com.azure.resourcemanager.iothub.fluent.models.JobResponseInner;
import com.azure.resourcemanager.iothub.fluent.models.RegistryStatisticsInner;
import com.azure.resourcemanager.iothub.fluent.models.SharedAccessSignatureAuthorizationRuleInner;
import com.azure.resourcemanager.iothub.fluent.models.TestAllRoutesResultInner;
import com.azure.resourcemanager.iothub.fluent.models.TestRouteResultInner;
import com.azure.resourcemanager.iothub.implementation.EndpointHealthDataImpl;
import com.azure.resourcemanager.iothub.implementation.EventHubConsumerGroupInfoImpl;
import com.azure.resourcemanager.iothub.implementation.IotHubDescriptionImpl;
import com.azure.resourcemanager.iothub.implementation.IotHubNameAvailabilityInfoImpl;
import com.azure.resourcemanager.iothub.implementation.IotHubQuotaMetricInfoImpl;
import com.azure.resourcemanager.iothub.implementation.IotHubSkuDescriptionImpl;
import com.azure.resourcemanager.iothub.implementation.JobResponseImpl;
import com.azure.resourcemanager.iothub.implementation.RegistryStatisticsImpl;
import com.azure.resourcemanager.iothub.implementation.SharedAccessSignatureAuthorizationRuleImpl;
import com.azure.resourcemanager.iothub.implementation.TestAllRoutesResultImpl;
import com.azure.resourcemanager.iothub.implementation.TestRouteResultImpl;
import com.azure.resourcemanager.iothub.implementation.Utils;
import com.azure.resourcemanager.iothub.models.EndpointHealthData;
import com.azure.resourcemanager.iothub.models.EventHubConsumerGroupInfo;
import com.azure.resourcemanager.iothub.models.ExportDevicesRequest;
import com.azure.resourcemanager.iothub.models.ImportDevicesRequest;
import com.azure.resourcemanager.iothub.models.IotHubDescription;
import com.azure.resourcemanager.iothub.models.IotHubNameAvailabilityInfo;
import com.azure.resourcemanager.iothub.models.IotHubQuotaMetricInfo;
import com.azure.resourcemanager.iothub.models.IotHubResources;
import com.azure.resourcemanager.iothub.models.IotHubSkuDescription;
import com.azure.resourcemanager.iothub.models.JobResponse;
import com.azure.resourcemanager.iothub.models.OperationInputs;
import com.azure.resourcemanager.iothub.models.RegistryStatistics;
import com.azure.resourcemanager.iothub.models.SharedAccessSignatureAuthorizationRule;
import com.azure.resourcemanager.iothub.models.TestAllRoutesInput;
import com.azure.resourcemanager.iothub.models.TestAllRoutesResult;
import com.azure.resourcemanager.iothub.models.TestRouteInput;
import com.azure.resourcemanager.iothub.models.TestRouteResult;

public final class IotHubResourcesImpl
implements IotHubResources {
    private static final ClientLogger LOGGER = new ClientLogger(IotHubResourcesImpl.class);
    private final IotHubResourcesClient innerClient;
    private final IotHubManager serviceManager;

    public IotHubResourcesImpl(IotHubResourcesClient innerClient, IotHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<IotHubDescription> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<IotHubDescriptionInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IotHubDescriptionImpl((IotHubDescriptionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IotHubDescription getByResourceGroup(String resourceGroupName, String resourceName) {
        IotHubDescriptionInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, resourceName);
        if (inner != null) {
            return new IotHubDescriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IotHubDescription deleteByResourceGroup(String resourceGroupName, String resourceName) {
        IotHubDescriptionInner inner = this.serviceClient().delete(resourceGroupName, resourceName);
        if (inner != null) {
            return new IotHubDescriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IotHubDescription delete(String resourceGroupName, String resourceName, Context context) {
        IotHubDescriptionInner inner = this.serviceClient().delete(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new IotHubDescriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<IotHubDescription> list() {
        PagedIterable<IotHubDescriptionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new IotHubDescriptionImpl((IotHubDescriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IotHubDescription> list(Context context) {
        PagedIterable<IotHubDescriptionInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new IotHubDescriptionImpl((IotHubDescriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IotHubDescription> listByResourceGroup(String resourceGroupName) {
        PagedIterable<IotHubDescriptionInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new IotHubDescriptionImpl((IotHubDescriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IotHubDescription> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<IotHubDescriptionInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new IotHubDescriptionImpl((IotHubDescriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<RegistryStatistics> getStatsWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<RegistryStatisticsInner> inner = this.serviceClient().getStatsWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegistryStatisticsImpl((RegistryStatisticsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RegistryStatistics getStats(String resourceGroupName, String resourceName) {
        RegistryStatisticsInner inner = this.serviceClient().getStats(resourceGroupName, resourceName);
        if (inner != null) {
            return new RegistryStatisticsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<IotHubSkuDescription> getValidSkus(String resourceGroupName, String resourceName) {
        PagedIterable<IotHubSkuDescriptionInner> inner = this.serviceClient().getValidSkus(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new IotHubSkuDescriptionImpl((IotHubSkuDescriptionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<IotHubSkuDescription> getValidSkus(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<IotHubSkuDescriptionInner> inner = this.serviceClient().getValidSkus(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new IotHubSkuDescriptionImpl((IotHubSkuDescriptionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<EventHubConsumerGroupInfo> listEventHubConsumerGroups(String resourceGroupName, String resourceName, String eventHubEndpointName) {
        PagedIterable<EventHubConsumerGroupInfoInner> inner = this.serviceClient().listEventHubConsumerGroups(resourceGroupName, resourceName, eventHubEndpointName);
        return Utils.mapPage(inner, inner1 -> new EventHubConsumerGroupInfoImpl((EventHubConsumerGroupInfoInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<EventHubConsumerGroupInfo> listEventHubConsumerGroups(String resourceGroupName, String resourceName, String eventHubEndpointName, Context context) {
        PagedIterable<EventHubConsumerGroupInfoInner> inner = this.serviceClient().listEventHubConsumerGroups(resourceGroupName, resourceName, eventHubEndpointName, context);
        return Utils.mapPage(inner, inner1 -> new EventHubConsumerGroupInfoImpl((EventHubConsumerGroupInfoInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<EventHubConsumerGroupInfo> getEventHubConsumerGroupWithResponse(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, Context context) {
        Response<EventHubConsumerGroupInfoInner> inner = this.serviceClient().getEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EventHubConsumerGroupInfoImpl((EventHubConsumerGroupInfoInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public EventHubConsumerGroupInfo getEventHubConsumerGroup(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        EventHubConsumerGroupInfoInner inner = this.serviceClient().getEventHubConsumerGroup(resourceGroupName, resourceName, eventHubEndpointName, name);
        if (inner != null) {
            return new EventHubConsumerGroupInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteEventHubConsumerGroupWithResponse(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, Context context) {
        return this.serviceClient().deleteEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, context);
    }

    @Override
    public void deleteEventHubConsumerGroup(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        this.serviceClient().deleteEventHubConsumerGroup(resourceGroupName, resourceName, eventHubEndpointName, name);
    }

    @Override
    public PagedIterable<JobResponse> listJobs(String resourceGroupName, String resourceName) {
        PagedIterable<JobResponseInner> inner = this.serviceClient().listJobs(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new JobResponseImpl((JobResponseInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<JobResponse> listJobs(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<JobResponseInner> inner = this.serviceClient().listJobs(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new JobResponseImpl((JobResponseInner)inner1, this.manager()));
    }

    @Override
    public Response<JobResponse> getJobWithResponse(String resourceGroupName, String resourceName, String jobId, Context context) {
        Response<JobResponseInner> inner = this.serviceClient().getJobWithResponse(resourceGroupName, resourceName, jobId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobResponseImpl((JobResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobResponse getJob(String resourceGroupName, String resourceName, String jobId) {
        JobResponseInner inner = this.serviceClient().getJob(resourceGroupName, resourceName, jobId);
        if (inner != null) {
            return new JobResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<IotHubQuotaMetricInfo> getQuotaMetrics(String resourceGroupName, String resourceName) {
        PagedIterable<IotHubQuotaMetricInfoInner> inner = this.serviceClient().getQuotaMetrics(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new IotHubQuotaMetricInfoImpl((IotHubQuotaMetricInfoInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<IotHubQuotaMetricInfo> getQuotaMetrics(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<IotHubQuotaMetricInfoInner> inner = this.serviceClient().getQuotaMetrics(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new IotHubQuotaMetricInfoImpl((IotHubQuotaMetricInfoInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<EndpointHealthData> getEndpointHealth(String resourceGroupName, String iotHubName) {
        PagedIterable<EndpointHealthDataInner> inner = this.serviceClient().getEndpointHealth(resourceGroupName, iotHubName);
        return Utils.mapPage(inner, inner1 -> new EndpointHealthDataImpl((EndpointHealthDataInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<EndpointHealthData> getEndpointHealth(String resourceGroupName, String iotHubName, Context context) {
        PagedIterable<EndpointHealthDataInner> inner = this.serviceClient().getEndpointHealth(resourceGroupName, iotHubName, context);
        return Utils.mapPage(inner, inner1 -> new EndpointHealthDataImpl((EndpointHealthDataInner)inner1, this.manager()));
    }

    @Override
    public Response<IotHubNameAvailabilityInfo> checkNameAvailabilityWithResponse(OperationInputs operationInputs, Context context) {
        Response<IotHubNameAvailabilityInfoInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(operationInputs, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IotHubNameAvailabilityInfoImpl((IotHubNameAvailabilityInfoInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IotHubNameAvailabilityInfo checkNameAvailability(OperationInputs operationInputs) {
        IotHubNameAvailabilityInfoInner inner = this.serviceClient().checkNameAvailability(operationInputs);
        if (inner != null) {
            return new IotHubNameAvailabilityInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TestAllRoutesResult> testAllRoutesWithResponse(String iotHubName, String resourceGroupName, TestAllRoutesInput input, Context context) {
        Response<TestAllRoutesResultInner> inner = this.serviceClient().testAllRoutesWithResponse(iotHubName, resourceGroupName, input, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TestAllRoutesResultImpl((TestAllRoutesResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TestAllRoutesResult testAllRoutes(String iotHubName, String resourceGroupName, TestAllRoutesInput input) {
        TestAllRoutesResultInner inner = this.serviceClient().testAllRoutes(iotHubName, resourceGroupName, input);
        if (inner != null) {
            return new TestAllRoutesResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TestRouteResult> testRouteWithResponse(String iotHubName, String resourceGroupName, TestRouteInput input, Context context) {
        Response<TestRouteResultInner> inner = this.serviceClient().testRouteWithResponse(iotHubName, resourceGroupName, input, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TestRouteResultImpl((TestRouteResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TestRouteResult testRoute(String iotHubName, String resourceGroupName, TestRouteInput input) {
        TestRouteResultInner inner = this.serviceClient().testRoute(iotHubName, resourceGroupName, input);
        if (inner != null) {
            return new TestRouteResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SharedAccessSignatureAuthorizationRule> listKeys(String resourceGroupName, String resourceName) {
        PagedIterable<SharedAccessSignatureAuthorizationRuleInner> inner = this.serviceClient().listKeys(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new SharedAccessSignatureAuthorizationRuleImpl((SharedAccessSignatureAuthorizationRuleInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SharedAccessSignatureAuthorizationRule> listKeys(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<SharedAccessSignatureAuthorizationRuleInner> inner = this.serviceClient().listKeys(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new SharedAccessSignatureAuthorizationRuleImpl((SharedAccessSignatureAuthorizationRuleInner)inner1, this.manager()));
    }

    @Override
    public Response<SharedAccessSignatureAuthorizationRule> getKeysForKeyNameWithResponse(String resourceGroupName, String resourceName, String keyName, Context context) {
        Response<SharedAccessSignatureAuthorizationRuleInner> inner = this.serviceClient().getKeysForKeyNameWithResponse(resourceGroupName, resourceName, keyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SharedAccessSignatureAuthorizationRuleImpl((SharedAccessSignatureAuthorizationRuleInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SharedAccessSignatureAuthorizationRule getKeysForKeyName(String resourceGroupName, String resourceName, String keyName) {
        SharedAccessSignatureAuthorizationRuleInner inner = this.serviceClient().getKeysForKeyName(resourceGroupName, resourceName, keyName);
        if (inner != null) {
            return new SharedAccessSignatureAuthorizationRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<JobResponse> exportDevicesWithResponse(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters, Context context) {
        Response<JobResponseInner> inner = this.serviceClient().exportDevicesWithResponse(resourceGroupName, resourceName, exportDevicesParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobResponseImpl((JobResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobResponse exportDevices(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters) {
        JobResponseInner inner = this.serviceClient().exportDevices(resourceGroupName, resourceName, exportDevicesParameters);
        if (inner != null) {
            return new JobResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<JobResponse> importDevicesWithResponse(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters, Context context) {
        Response<JobResponseInner> inner = this.serviceClient().importDevicesWithResponse(resourceGroupName, resourceName, importDevicesParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobResponseImpl((JobResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobResponse importDevices(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters) {
        JobResponseInner inner = this.serviceClient().importDevices(resourceGroupName, resourceName, importDevicesParameters);
        if (inner != null) {
            return new JobResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public IotHubDescription getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        return (IotHubDescription)this.getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @Override
    public Response<IotHubDescription> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public EventHubConsumerGroupInfo getEventHubConsumerGroupById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        String eventHubEndpointName = Utils.getValueFromIdByName(id, "eventHubEndpoints");
        if (eventHubEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventHubEndpoints'.", id)));
        }
        String name = Utils.getValueFromIdByName(id, "ConsumerGroups");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'ConsumerGroups'.", id)));
        }
        return (EventHubConsumerGroupInfo)this.getEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, Context.NONE).getValue();
    }

    @Override
    public Response<EventHubConsumerGroupInfo> getEventHubConsumerGroupByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        String eventHubEndpointName = Utils.getValueFromIdByName(id, "eventHubEndpoints");
        if (eventHubEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventHubEndpoints'.", id)));
        }
        String name = Utils.getValueFromIdByName(id, "ConsumerGroups");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'ConsumerGroups'.", id)));
        }
        return this.getEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, context);
    }

    @Override
    public IotHubDescription deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        return this.delete(resourceGroupName, resourceName, Context.NONE);
    }

    @Override
    public IotHubDescription deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        return this.delete(resourceGroupName, resourceName, context);
    }

    @Override
    public void deleteEventHubConsumerGroupById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        String eventHubEndpointName = Utils.getValueFromIdByName(id, "eventHubEndpoints");
        if (eventHubEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventHubEndpoints'.", id)));
        }
        String name = Utils.getValueFromIdByName(id, "ConsumerGroups");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'ConsumerGroups'.", id)));
        }
        this.deleteEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, Context.NONE);
    }

    @Override
    public Response<Void> deleteEventHubConsumerGroupByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "IotHubs");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'IotHubs'.", id)));
        }
        String eventHubEndpointName = Utils.getValueFromIdByName(id, "eventHubEndpoints");
        if (eventHubEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventHubEndpoints'.", id)));
        }
        String name = Utils.getValueFromIdByName(id, "ConsumerGroups");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'ConsumerGroups'.", id)));
        }
        return this.deleteEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, context);
    }

    private IotHubResourcesClient serviceClient() {
        return this.innerClient;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public IotHubDescriptionImpl define(String name) {
        return new IotHubDescriptionImpl(name, this.manager());
    }

    @Override
    public EventHubConsumerGroupInfoImpl defineEventHubConsumerGroup(String name) {
        return new EventHubConsumerGroupInfoImpl(name, this.manager());
    }
}

