/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.models.IotHubDescriptionInner;
import com.azure.resourcemanager.iothub.implementation.Utils;
import com.azure.resourcemanager.iothub.models.ArmIdentity;
import com.azure.resourcemanager.iothub.models.ExportDevicesRequest;
import com.azure.resourcemanager.iothub.models.ImportDevicesRequest;
import com.azure.resourcemanager.iothub.models.IotHubDescription;
import com.azure.resourcemanager.iothub.models.IotHubProperties;
import com.azure.resourcemanager.iothub.models.IotHubSkuInfo;
import com.azure.resourcemanager.iothub.models.JobResponse;
import com.azure.resourcemanager.iothub.models.SharedAccessSignatureAuthorizationRule;
import com.azure.resourcemanager.iothub.models.TagsResource;
import java.util.Collections;
import java.util.Map;

public final class IotHubDescriptionImpl
implements IotHubDescription,
IotHubDescription.Definition,
IotHubDescription.Update {
    private IotHubDescriptionInner innerObject;
    private final IotHubManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private String createIfMatch;
    private TagsResource updateIotHubTags;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public IotHubProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public IotHubSkuInfo sku() {
        return this.innerModel().sku();
    }

    @Override
    public ArmIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IotHubDescriptionInner innerModel() {
        return this.innerObject;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public IotHubDescriptionImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public IotHubDescription create() {
        this.innerObject = this.serviceManager.serviceClient().getIotHubResources().createOrUpdate(this.resourceGroupName, this.resourceName, this.innerModel(), this.createIfMatch, Context.NONE);
        return this;
    }

    @Override
    public IotHubDescription create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIotHubResources().createOrUpdate(this.resourceGroupName, this.resourceName, this.innerModel(), this.createIfMatch, context);
        return this;
    }

    IotHubDescriptionImpl(String name, IotHubManager serviceManager) {
        this.innerObject = new IotHubDescriptionInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
        this.createIfMatch = null;
    }

    @Override
    public IotHubDescriptionImpl update() {
        this.updateIotHubTags = new TagsResource();
        return this;
    }

    @Override
    public IotHubDescription apply() {
        this.innerObject = this.serviceManager.serviceClient().getIotHubResources().update(this.resourceGroupName, this.resourceName, this.updateIotHubTags, Context.NONE);
        return this;
    }

    @Override
    public IotHubDescription apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIotHubResources().update(this.resourceGroupName, this.resourceName, this.updateIotHubTags, context);
        return this;
    }

    IotHubDescriptionImpl(IotHubDescriptionInner innerObject, IotHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "IotHubs");
    }

    @Override
    public IotHubDescription refresh() {
        this.innerObject = (IotHubDescriptionInner)((Object)this.serviceManager.serviceClient().getIotHubResources().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public IotHubDescription refresh(Context context) {
        this.innerObject = (IotHubDescriptionInner)((Object)this.serviceManager.serviceClient().getIotHubResources().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, context).getValue());
        return this;
    }

    @Override
    public PagedIterable<SharedAccessSignatureAuthorizationRule> listKeys() {
        return this.serviceManager.iotHubResources().listKeys(this.resourceGroupName, this.resourceName);
    }

    @Override
    public PagedIterable<SharedAccessSignatureAuthorizationRule> listKeys(Context context) {
        return this.serviceManager.iotHubResources().listKeys(this.resourceGroupName, this.resourceName, context);
    }

    @Override
    public Response<JobResponse> exportDevicesWithResponse(ExportDevicesRequest exportDevicesParameters, Context context) {
        return this.serviceManager.iotHubResources().exportDevicesWithResponse(this.resourceGroupName, this.resourceName, exportDevicesParameters, context);
    }

    @Override
    public JobResponse exportDevices(ExportDevicesRequest exportDevicesParameters) {
        return this.serviceManager.iotHubResources().exportDevices(this.resourceGroupName, this.resourceName, exportDevicesParameters);
    }

    @Override
    public Response<JobResponse> importDevicesWithResponse(ImportDevicesRequest importDevicesParameters, Context context) {
        return this.serviceManager.iotHubResources().importDevicesWithResponse(this.resourceGroupName, this.resourceName, importDevicesParameters, context);
    }

    @Override
    public JobResponse importDevices(ImportDevicesRequest importDevicesParameters) {
        return this.serviceManager.iotHubResources().importDevices(this.resourceGroupName, this.resourceName, importDevicesParameters);
    }

    @Override
    public IotHubDescriptionImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public IotHubDescriptionImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public IotHubDescriptionImpl withSku(IotHubSkuInfo sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public IotHubDescriptionImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateIotHubTags.withTags(tags);
        return this;
    }

    @Override
    public IotHubDescriptionImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public IotHubDescriptionImpl withProperties(IotHubProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public IotHubDescriptionImpl withIdentity(ArmIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public IotHubDescriptionImpl withIfMatch(String ifMatch) {
        this.createIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

