/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.iothub.fluent.CertificatesClient;
import com.azure.resourcemanager.iothub.fluent.models.CertificateDescriptionInner;
import com.azure.resourcemanager.iothub.fluent.models.CertificateListDescriptionInner;
import com.azure.resourcemanager.iothub.fluent.models.CertificateWithNonceDescriptionInner;
import com.azure.resourcemanager.iothub.implementation.IotHubClientImpl;
import com.azure.resourcemanager.iothub.models.CertificateVerificationDescription;
import com.azure.resourcemanager.iothub.models.ErrorDetailsException;
import reactor.core.publisher.Mono;

public final class CertificatesClientImpl
implements CertificatesClient {
    private final CertificatesService service;
    private final IotHubClientImpl client;

    CertificatesClientImpl(IotHubClientImpl client) {
        this.service = (CertificatesService)RestProxy.create(CertificatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateListDescriptionInner>> listByIotHubWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByIotHub(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateListDescriptionInner>> listByIotHubWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByIotHub(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CertificateListDescriptionInner> listByIotHubAsync(String resourceGroupName, String resourceName) {
        return this.listByIotHubWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((CertificateListDescriptionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateListDescriptionInner> listByIotHubWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.listByIotHubWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateListDescriptionInner listByIotHub(String resourceGroupName, String resourceName) {
        return (CertificateListDescriptionInner)this.listByIotHubWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateDescriptionInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String certificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateDescriptionInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CertificateDescriptionInner> getAsync(String resourceGroupName, String resourceName, String certificateName) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, certificateName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CertificateDescriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateDescriptionInner> getWithResponse(String resourceGroupName, String resourceName, String certificateName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, certificateName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateDescriptionInner get(String resourceGroupName, String resourceName, String certificateName) {
        return (CertificateDescriptionInner)((Object)this.getWithResponse(resourceGroupName, resourceName, certificateName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateDescriptionInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, CertificateDescriptionInner certificateDescription, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateDescription == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateDescription is required and cannot be null."));
        }
        certificateDescription.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, certificateDescription, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateDescriptionInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, CertificateDescriptionInner certificateDescription, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (certificateDescription == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateDescription is required and cannot be null."));
        }
        certificateDescription.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, certificateDescription, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CertificateDescriptionInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String certificateName, CertificateDescriptionInner certificateDescription) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, certificateName, certificateDescription, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CertificateDescriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateDescriptionInner> createOrUpdateWithResponse(String resourceGroupName, String resourceName, String certificateName, CertificateDescriptionInner certificateDescription, String ifMatch, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, certificateName, certificateDescription, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateDescriptionInner createOrUpdate(String resourceGroupName, String resourceName, String certificateName, CertificateDescriptionInner certificateDescription) {
        String ifMatch = null;
        return (CertificateDescriptionInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, resourceName, certificateName, certificateDescription, ifMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, certificateName, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String certificateName, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, certificateName, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String certificateName, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, resourceName, certificateName, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateWithNonceDescriptionInner>> generateVerificationCodeWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateVerificationCode(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateWithNonceDescriptionInner>> generateVerificationCodeWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.generateVerificationCode(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CertificateWithNonceDescriptionInner> generateVerificationCodeAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch) {
        return this.generateVerificationCodeWithResponseAsync(resourceGroupName, resourceName, certificateName, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CertificateWithNonceDescriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateWithNonceDescriptionInner> generateVerificationCodeWithResponse(String resourceGroupName, String resourceName, String certificateName, String ifMatch, Context context) {
        return (Response)this.generateVerificationCodeWithResponseAsync(resourceGroupName, resourceName, certificateName, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateWithNonceDescriptionInner generateVerificationCode(String resourceGroupName, String resourceName, String certificateName, String ifMatch) {
        return (CertificateWithNonceDescriptionInner)((Object)this.generateVerificationCodeWithResponse(resourceGroupName, resourceName, certificateName, ifMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateDescriptionInner>> verifyWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch, CertificateVerificationDescription certificateVerificationBody) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (certificateVerificationBody == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateVerificationBody is required and cannot be null."));
        }
        certificateVerificationBody.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.verify(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, certificateVerificationBody, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CertificateDescriptionInner>> verifyWithResponseAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch, CertificateVerificationDescription certificateVerificationBody, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (certificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateName is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (certificateVerificationBody == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateVerificationBody is required and cannot be null."));
        }
        certificateVerificationBody.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.verify(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, certificateName, ifMatch, certificateVerificationBody, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CertificateDescriptionInner> verifyAsync(String resourceGroupName, String resourceName, String certificateName, String ifMatch, CertificateVerificationDescription certificateVerificationBody) {
        return this.verifyWithResponseAsync(resourceGroupName, resourceName, certificateName, ifMatch, certificateVerificationBody).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CertificateDescriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateDescriptionInner> verifyWithResponse(String resourceGroupName, String resourceName, String certificateName, String ifMatch, CertificateVerificationDescription certificateVerificationBody, Context context) {
        return (Response)this.verifyWithResponseAsync(resourceGroupName, resourceName, certificateName, ifMatch, certificateVerificationBody, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateDescriptionInner verify(String resourceGroupName, String resourceName, String certificateName, String ifMatch, CertificateVerificationDescription certificateVerificationBody) {
        return (CertificateDescriptionInner)((Object)this.verifyWithResponse(resourceGroupName, resourceName, certificateName, ifMatch, certificateVerificationBody, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="IotHubClientCertific")
    public static interface CertificatesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<CertificateListDescriptionInner>> listByIotHub(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<CertificateDescriptionInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="certificateName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<CertificateDescriptionInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="certificateName") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") CertificateDescriptionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="certificateName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}/generateVerificationCode")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<CertificateWithNonceDescriptionInner>> generateVerificationCode(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="certificateName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}/verify")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<CertificateDescriptionInner>> verify(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="certificateName") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") CertificateVerificationDescription var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

