/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.DnsResourceReferencesClient;
import com.azure.resourcemanager.dns.fluent.RecordSetsClient;
import com.azure.resourcemanager.dns.fluent.ZonesClient;
import com.azure.resourcemanager.dns.implementation.DnsManagementClientBuilder;
import com.azure.resourcemanager.dns.implementation.DnsResourceReferencesClientImpl;
import com.azure.resourcemanager.dns.implementation.RecordSetsClientImpl;
import com.azure.resourcemanager.dns.implementation.ZonesClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=DnsManagementClientBuilder.class)
public final class DnsManagementClientImpl
extends AzureServiceClient
implements DnsManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final RecordSetsClient recordSets;
    private final ZonesClient zones;
    private final DnsResourceReferencesClient dnsResourceReferences;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public RecordSetsClient getRecordSets() {
        return this.recordSets;
    }

    @Override
    public ZonesClient getZones() {
        return this.zones;
    }

    @Override
    public DnsResourceReferencesClient getDnsResourceReferences() {
        return this.dnsResourceReferences;
    }

    DnsManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2018-05-01";
        this.recordSets = new RecordSetsClientImpl(this);
        this.zones = new ZonesClientImpl(this);
        this.dnsResourceReferences = new DnsResourceReferencesClientImpl(this);
    }
}

