/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.WebActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebActivityMethod;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class WebActivity
extends ExecutionActivity {
    private String type = "WebActivity";
    private WebActivityTypeProperties innerTypeProperties = new WebActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(WebActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    WebActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public WebActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public WebActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public WebActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public WebActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public WebActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public WebActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public WebActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public WebActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public WebActivityMethod method() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().method();
    }

    public WebActivity withMethod(WebActivityMethod method) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withMethod(method);
        return this;
    }

    public Object url() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().url();
    }

    public WebActivity withUrl(Object url) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withUrl(url);
        return this;
    }

    public Map<String, Object> headers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().headers();
    }

    public WebActivity withHeaders(Map<String, Object> headers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withHeaders(headers);
        return this;
    }

    public Object body() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().body();
    }

    public WebActivity withBody(Object body) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withBody(body);
        return this;
    }

    public WebActivityAuthentication authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    public WebActivity withAuthentication(WebActivityAuthentication authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    public Boolean disableCertValidation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().disableCertValidation();
    }

    public WebActivity withDisableCertValidation(Boolean disableCertValidation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withDisableCertValidation(disableCertValidation);
        return this;
    }

    public Object httpRequestTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().httpRequestTimeout();
    }

    public WebActivity withHttpRequestTimeout(Object httpRequestTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withHttpRequestTimeout(httpRequestTimeout);
        return this;
    }

    public Boolean turnOffAsync() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().turnOffAsync();
    }

    public WebActivity withTurnOffAsync(Boolean turnOffAsync) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withTurnOffAsync(turnOffAsync);
        return this;
    }

    public List<DatasetReference> datasets() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().datasets();
    }

    public WebActivity withDatasets(List<DatasetReference> datasets) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withDatasets(datasets);
        return this;
    }

    public List<LinkedServiceReference> linkedServices() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedServices();
    }

    public WebActivity withLinkedServices(List<LinkedServiceReference> linkedServices) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withLinkedServices(linkedServices);
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectVia();
    }

    public WebActivity withConnectVia(IntegrationRuntimeReference connectVia) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withConnectVia(connectVia);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model WebActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model WebActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WebActivity fromJson(JsonReader jsonReader) throws IOException {
        return (WebActivity)jsonReader.readObject(reader -> {
            WebActivity deserializedWebActivity = new WebActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWebActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWebActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedWebActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedWebActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedWebActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedWebActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedWebActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedWebActivity.innerTypeProperties = WebActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWebActivity.withAdditionalProperties(additionalProperties);
            return deserializedWebActivity;
        });
    }
}

