/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SqlPartitionSettings;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class WarehouseSource
extends TabularSource {
    private String type = "WarehouseSource";
    private Object sqlReaderQuery;
    private Object sqlReaderStoredProcedureName;
    private Object storedProcedureParameters;
    private Object isolationLevel;
    private Object partitionOption;
    private SqlPartitionSettings partitionSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object sqlReaderQuery() {
        return this.sqlReaderQuery;
    }

    public WarehouseSource withSqlReaderQuery(Object sqlReaderQuery) {
        this.sqlReaderQuery = sqlReaderQuery;
        return this;
    }

    public Object sqlReaderStoredProcedureName() {
        return this.sqlReaderStoredProcedureName;
    }

    public WarehouseSource withSqlReaderStoredProcedureName(Object sqlReaderStoredProcedureName) {
        this.sqlReaderStoredProcedureName = sqlReaderStoredProcedureName;
        return this;
    }

    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public WarehouseSource withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object isolationLevel() {
        return this.isolationLevel;
    }

    public WarehouseSource withIsolationLevel(Object isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public Object partitionOption() {
        return this.partitionOption;
    }

    public WarehouseSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SqlPartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    public WarehouseSource withPartitionSettings(SqlPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public WarehouseSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public WarehouseSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public WarehouseSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public WarehouseSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public WarehouseSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public WarehouseSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.partitionSettings() != null) {
            this.partitionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.queryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        }
        if (this.additionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.sqlReaderQuery != null) {
            jsonWriter.writeUntypedField("sqlReaderQuery", this.sqlReaderQuery);
        }
        if (this.sqlReaderStoredProcedureName != null) {
            jsonWriter.writeUntypedField("sqlReaderStoredProcedureName", this.sqlReaderStoredProcedureName);
        }
        if (this.storedProcedureParameters != null) {
            jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        }
        if (this.isolationLevel != null) {
            jsonWriter.writeUntypedField("isolationLevel", this.isolationLevel);
        }
        if (this.partitionOption != null) {
            jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        }
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WarehouseSource fromJson(JsonReader jsonReader) throws IOException {
        return (WarehouseSource)jsonReader.readObject(reader -> {
            WarehouseSource deserializedWarehouseSource = new WarehouseSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedWarehouseSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedWarehouseSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedWarehouseSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedWarehouseSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedWarehouseSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedWarehouseSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWarehouseSource.type = reader.getString();
                    continue;
                }
                if ("sqlReaderQuery".equals(fieldName)) {
                    deserializedWarehouseSource.sqlReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("sqlReaderStoredProcedureName".equals(fieldName)) {
                    deserializedWarehouseSource.sqlReaderStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedWarehouseSource.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("isolationLevel".equals(fieldName)) {
                    deserializedWarehouseSource.isolationLevel = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedWarehouseSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedWarehouseSource.partitionSettings = SqlPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWarehouseSource.withAdditionalProperties(additionalProperties);
            return deserializedWarehouseSource;
        });
    }
}

