/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UserProperty
implements JsonSerializable<UserProperty> {
    private String name;
    private Object value;
    private static final ClientLogger LOGGER = new ClientLogger(UserProperty.class);

    public String name() {
        return this.name;
    }

    public UserProperty withName(String name) {
        this.name = name;
        return this;
    }

    public Object value() {
        return this.value;
    }

    public UserProperty withValue(Object value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model UserProperty"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model UserProperty"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeUntypedField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static UserProperty fromJson(JsonReader jsonReader) throws IOException {
        return (UserProperty)jsonReader.readObject(reader -> {
            UserProperty deserializedUserProperty = new UserProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedUserProperty.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedUserProperty.value = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserProperty;
        });
    }
}

