/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerResourceInner;
import java.io.IOException;
import java.util.List;

public final class TriggerListResponse
implements JsonSerializable<TriggerListResponse> {
    private List<TriggerResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(TriggerListResponse.class);

    public List<TriggerResourceInner> value() {
        return this.value;
    }

    public TriggerListResponse withValue(List<TriggerResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public TriggerListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model TriggerListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static TriggerListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerListResponse)jsonReader.readObject(reader -> {
            TriggerListResponse deserializedTriggerListResponse = new TriggerListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTriggerListResponse.value = value = reader.readArray(reader1 -> TriggerResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedTriggerListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerListResponse;
        });
    }
}

