/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.TeradataLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.TeradataAuthenticationType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TeradataLinkedService
extends LinkedService {
    private String type = "Teradata";
    private TeradataLinkedServiceTypeProperties innerTypeProperties = new TeradataLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(TeradataLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    TeradataLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public TeradataLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public TeradataLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public TeradataLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public TeradataLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public TeradataLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public TeradataLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public TeradataLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public TeradataAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public TeradataLinkedService withAuthenticationType(TeradataAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public TeradataLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public TeradataLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object sslMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslMode();
    }

    public TeradataLinkedService withSslMode(Object sslMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslMode(sslMode);
        return this;
    }

    public Object portNumber() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().portNumber();
    }

    public TeradataLinkedService withPortNumber(Object portNumber) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPortNumber(portNumber);
        return this;
    }

    public Object httpsPortNumber() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().httpsPortNumber();
    }

    public TeradataLinkedService withHttpsPortNumber(Object httpsPortNumber) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHttpsPortNumber(httpsPortNumber);
        return this;
    }

    public Object useDataEncryption() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useDataEncryption();
    }

    public TeradataLinkedService withUseDataEncryption(Object useDataEncryption) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseDataEncryption(useDataEncryption);
        return this;
    }

    public Object characterSet() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().characterSet();
    }

    public TeradataLinkedService withCharacterSet(Object characterSet) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCharacterSet(characterSet);
        return this;
    }

    public Object maxRespSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxRespSize();
    }

    public TeradataLinkedService withMaxRespSize(Object maxRespSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMaxRespSize(maxRespSize);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public TeradataLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TeradataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model TeradataLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TeradataLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (TeradataLinkedService)jsonReader.readObject(reader -> {
            TeradataLinkedService deserializedTeradataLinkedService = new TeradataLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedTeradataLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedTeradataLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTeradataLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedTeradataLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedTeradataLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedTeradataLinkedService.innerTypeProperties = TeradataLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTeradataLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTeradataLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedTeradataLinkedService;
        });
    }
}

