/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SsisEnvironment;
import com.azure.resourcemanager.datafactory.models.SsisFolder;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataType;
import com.azure.resourcemanager.datafactory.models.SsisPackage;
import com.azure.resourcemanager.datafactory.models.SsisProject;
import java.io.IOException;

public class SsisObjectMetadata
implements JsonSerializable<SsisObjectMetadata> {
    private SsisObjectMetadataType type = SsisObjectMetadataType.fromString("SsisObjectMetadata");
    private Long id;
    private String name;
    private String description;

    public SsisObjectMetadataType type() {
        return this.type;
    }

    public Long id() {
        return this.id;
    }

    public SsisObjectMetadata withId(Long id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SsisObjectMetadata withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SsisObjectMetadata withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("id", (Number)this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SsisObjectMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (SsisObjectMetadata)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                SsisObjectMetadata ssisObjectMetadata;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Folder".equals(discriminatorValue)) {
                    ssisObjectMetadata = SsisFolder.fromJson(readerToUse.reset());
                    return ssisObjectMetadata;
                }
                if ("Project".equals(discriminatorValue)) {
                    ssisObjectMetadata = SsisProject.fromJson(readerToUse.reset());
                    return ssisObjectMetadata;
                }
                if ("Package".equals(discriminatorValue)) {
                    ssisObjectMetadata = SsisPackage.fromJson(readerToUse.reset());
                    return ssisObjectMetadata;
                }
                if ("Environment".equals(discriminatorValue)) {
                    ssisObjectMetadata = SsisEnvironment.fromJson(readerToUse.reset());
                    return ssisObjectMetadata;
                }
                ssisObjectMetadata = SsisObjectMetadata.fromJsonKnownDiscriminator(readerToUse.reset());
                return ssisObjectMetadata;
            }
        });
    }

    static SsisObjectMetadata fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (SsisObjectMetadata)jsonReader.readObject(reader -> {
            SsisObjectMetadata deserializedSsisObjectMetadata = new SsisObjectMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSsisObjectMetadata.type = SsisObjectMetadataType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSsisObjectMetadata.id = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSsisObjectMetadata.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSsisObjectMetadata.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisObjectMetadata;
        });
    }
}

