/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecureString;
import java.io.IOException;

public final class SsisExecutionCredential
implements JsonSerializable<SsisExecutionCredential> {
    private Object domain;
    private Object username;
    private SecureString password;
    private static final ClientLogger LOGGER = new ClientLogger(SsisExecutionCredential.class);

    public Object domain() {
        return this.domain;
    }

    public SsisExecutionCredential withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SsisExecutionCredential withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecureString password() {
        return this.password;
    }

    public SsisExecutionCredential withPassword(SecureString password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.domain() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domain in model SsisExecutionCredential"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model SsisExecutionCredential"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model SsisExecutionCredential"));
        }
        this.password().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("domain", this.domain);
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        return jsonWriter.writeEndObject();
    }

    public static SsisExecutionCredential fromJson(JsonReader jsonReader) throws IOException {
        return (SsisExecutionCredential)jsonReader.readObject(reader -> {
            SsisExecutionCredential deserializedSsisExecutionCredential = new SsisExecutionCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domain".equals(fieldName)) {
                    deserializedSsisExecutionCredential.domain = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSsisExecutionCredential.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSsisExecutionCredential.password = SecureString.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisExecutionCredential;
        });
    }
}

