/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ScriptAction
implements JsonSerializable<ScriptAction> {
    private String name;
    private String uri;
    private Object roles;
    private String parameters;
    private static final ClientLogger LOGGER = new ClientLogger(ScriptAction.class);

    public String name() {
        return this.name;
    }

    public ScriptAction withName(String name) {
        this.name = name;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ScriptAction withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Object roles() {
        return this.roles;
    }

    public ScriptAction withRoles(Object roles) {
        this.roles = roles;
        return this;
    }

    public String parameters() {
        return this.parameters;
    }

    public ScriptAction withParameters(String parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ScriptAction"));
        }
        if (this.uri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property uri in model ScriptAction"));
        }
        if (this.roles() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roles in model ScriptAction"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeUntypedField("roles", this.roles);
        jsonWriter.writeStringField("parameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ScriptAction fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptAction)jsonReader.readObject(reader -> {
            ScriptAction deserializedScriptAction = new ScriptAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedScriptAction.name = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedScriptAction.uri = reader.getString();
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    deserializedScriptAction.roles = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedScriptAction.parameters = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptAction;
        });
    }
}

