/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataMapperMapping;
import com.azure.resourcemanager.datafactory.models.MapperConnection;
import com.azure.resourcemanager.datafactory.models.MapperTable;
import java.io.IOException;
import java.util.List;

public final class MapperTargetConnectionsInfo
implements JsonSerializable<MapperTargetConnectionsInfo> {
    private List<MapperTable> targetEntities;
    private MapperConnection connection;
    private List<DataMapperMapping> dataMapperMappings;
    private List<Object> relationships;

    public List<MapperTable> targetEntities() {
        return this.targetEntities;
    }

    public MapperTargetConnectionsInfo withTargetEntities(List<MapperTable> targetEntities) {
        this.targetEntities = targetEntities;
        return this;
    }

    public MapperConnection connection() {
        return this.connection;
    }

    public MapperTargetConnectionsInfo withConnection(MapperConnection connection) {
        this.connection = connection;
        return this;
    }

    public List<DataMapperMapping> dataMapperMappings() {
        return this.dataMapperMappings;
    }

    public MapperTargetConnectionsInfo withDataMapperMappings(List<DataMapperMapping> dataMapperMappings) {
        this.dataMapperMappings = dataMapperMappings;
        return this;
    }

    public List<Object> relationships() {
        return this.relationships;
    }

    public MapperTargetConnectionsInfo withRelationships(List<Object> relationships) {
        this.relationships = relationships;
        return this;
    }

    public void validate() {
        if (this.targetEntities() != null) {
            this.targetEntities().forEach(e -> e.validate());
        }
        if (this.connection() != null) {
            this.connection().validate();
        }
        if (this.dataMapperMappings() != null) {
            this.dataMapperMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetEntities", this.targetEntities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("connection", (JsonSerializable)this.connection);
        jsonWriter.writeArrayField("dataMapperMappings", this.dataMapperMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("relationships", this.relationships, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static MapperTargetConnectionsInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MapperTargetConnectionsInfo)jsonReader.readObject(reader -> {
            MapperTargetConnectionsInfo deserializedMapperTargetConnectionsInfo = new MapperTargetConnectionsInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetEntities".equals(fieldName)) {
                    List targetEntities;
                    deserializedMapperTargetConnectionsInfo.targetEntities = targetEntities = reader.readArray(reader1 -> MapperTable.fromJson(reader1));
                    continue;
                }
                if ("connection".equals(fieldName)) {
                    deserializedMapperTargetConnectionsInfo.connection = MapperConnection.fromJson(reader);
                    continue;
                }
                if ("dataMapperMappings".equals(fieldName)) {
                    List dataMapperMappings;
                    deserializedMapperTargetConnectionsInfo.dataMapperMappings = dataMapperMappings = reader.readArray(reader1 -> DataMapperMapping.fromJson(reader1));
                    continue;
                }
                if ("relationships".equals(fieldName)) {
                    List relationships;
                    deserializedMapperTargetConnectionsInfo.relationships = relationships = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperTargetConnectionsInfo;
        });
    }
}

