/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowComputeType;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IntegrationRuntimeDataFlowProperties
implements JsonSerializable<IntegrationRuntimeDataFlowProperties> {
    private DataFlowComputeType computeType;
    private Integer coreCount;
    private Integer timeToLive;
    private Boolean cleanup;
    private List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem> customProperties;
    private Map<String, Object> additionalProperties;

    public DataFlowComputeType computeType() {
        return this.computeType;
    }

    public IntegrationRuntimeDataFlowProperties withComputeType(DataFlowComputeType computeType) {
        this.computeType = computeType;
        return this;
    }

    public Integer coreCount() {
        return this.coreCount;
    }

    public IntegrationRuntimeDataFlowProperties withCoreCount(Integer coreCount) {
        this.coreCount = coreCount;
        return this;
    }

    public Integer timeToLive() {
        return this.timeToLive;
    }

    public IntegrationRuntimeDataFlowProperties withTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public Boolean cleanup() {
        return this.cleanup;
    }

    public IntegrationRuntimeDataFlowProperties withCleanup(Boolean cleanup) {
        this.cleanup = cleanup;
        return this;
    }

    public List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem> customProperties() {
        return this.customProperties;
    }

    public IntegrationRuntimeDataFlowProperties withCustomProperties(List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeDataFlowProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.customProperties() != null) {
            this.customProperties().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("computeType", this.computeType == null ? null : this.computeType.toString());
        jsonWriter.writeNumberField("coreCount", (Number)this.coreCount);
        jsonWriter.writeNumberField("timeToLive", (Number)this.timeToLive);
        jsonWriter.writeBooleanField("cleanup", this.cleanup);
        jsonWriter.writeArrayField("customProperties", this.customProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeDataFlowProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeDataFlowProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeDataFlowProperties deserializedIntegrationRuntimeDataFlowProperties = new IntegrationRuntimeDataFlowProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computeType".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.computeType = DataFlowComputeType.fromString(reader.getString());
                    continue;
                }
                if ("coreCount".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.coreCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timeToLive".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.timeToLive = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cleanup".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataFlowProperties.cleanup = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customProperties".equals(fieldName)) {
                    List customProperties;
                    deserializedIntegrationRuntimeDataFlowProperties.customProperties = customProperties = reader.readArray(reader1 -> IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeDataFlowProperties.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeDataFlowProperties;
        });
    }
}

