/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FileServerReadSettings
extends StoreReadSettings {
    private String type = "FileServerReadSettings";
    private Object recursive;
    private Object wildcardFolderPath;
    private Object wildcardFileName;
    private Object fileListPath;
    private Object enablePartitionDiscovery;
    private Object partitionRootPath;
    private Object deleteFilesAfterCompletion;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private Object fileFilter;

    @Override
    public String type() {
        return this.type;
    }

    public Object recursive() {
        return this.recursive;
    }

    public FileServerReadSettings withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Object wildcardFolderPath() {
        return this.wildcardFolderPath;
    }

    public FileServerReadSettings withWildcardFolderPath(Object wildcardFolderPath) {
        this.wildcardFolderPath = wildcardFolderPath;
        return this;
    }

    public Object wildcardFileName() {
        return this.wildcardFileName;
    }

    public FileServerReadSettings withWildcardFileName(Object wildcardFileName) {
        this.wildcardFileName = wildcardFileName;
        return this;
    }

    public Object fileListPath() {
        return this.fileListPath;
    }

    public FileServerReadSettings withFileListPath(Object fileListPath) {
        this.fileListPath = fileListPath;
        return this;
    }

    public Object enablePartitionDiscovery() {
        return this.enablePartitionDiscovery;
    }

    public FileServerReadSettings withEnablePartitionDiscovery(Object enablePartitionDiscovery) {
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        return this;
    }

    public Object partitionRootPath() {
        return this.partitionRootPath;
    }

    public FileServerReadSettings withPartitionRootPath(Object partitionRootPath) {
        this.partitionRootPath = partitionRootPath;
        return this;
    }

    public Object deleteFilesAfterCompletion() {
        return this.deleteFilesAfterCompletion;
    }

    public FileServerReadSettings withDeleteFilesAfterCompletion(Object deleteFilesAfterCompletion) {
        this.deleteFilesAfterCompletion = deleteFilesAfterCompletion;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public FileServerReadSettings withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public FileServerReadSettings withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public Object fileFilter() {
        return this.fileFilter;
    }

    public FileServerReadSettings withFileFilter(Object fileFilter) {
        this.fileFilter = fileFilter;
        return this;
    }

    @Override
    public FileServerReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public FileServerReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.recursive != null) {
            jsonWriter.writeUntypedField("recursive", this.recursive);
        }
        if (this.wildcardFolderPath != null) {
            jsonWriter.writeUntypedField("wildcardFolderPath", this.wildcardFolderPath);
        }
        if (this.wildcardFileName != null) {
            jsonWriter.writeUntypedField("wildcardFileName", this.wildcardFileName);
        }
        if (this.fileListPath != null) {
            jsonWriter.writeUntypedField("fileListPath", this.fileListPath);
        }
        if (this.enablePartitionDiscovery != null) {
            jsonWriter.writeUntypedField("enablePartitionDiscovery", this.enablePartitionDiscovery);
        }
        if (this.partitionRootPath != null) {
            jsonWriter.writeUntypedField("partitionRootPath", this.partitionRootPath);
        }
        if (this.deleteFilesAfterCompletion != null) {
            jsonWriter.writeUntypedField("deleteFilesAfterCompletion", this.deleteFilesAfterCompletion);
        }
        if (this.modifiedDatetimeStart != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        }
        if (this.modifiedDatetimeEnd != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        }
        if (this.fileFilter != null) {
            jsonWriter.writeUntypedField("fileFilter", this.fileFilter);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FileServerReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (FileServerReadSettings)jsonReader.readObject(reader -> {
            FileServerReadSettings deserializedFileServerReadSettings = new FileServerReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedFileServerReadSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedFileServerReadSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileServerReadSettings.type = reader.getString();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedFileServerReadSettings.recursive = reader.readUntyped();
                    continue;
                }
                if ("wildcardFolderPath".equals(fieldName)) {
                    deserializedFileServerReadSettings.wildcardFolderPath = reader.readUntyped();
                    continue;
                }
                if ("wildcardFileName".equals(fieldName)) {
                    deserializedFileServerReadSettings.wildcardFileName = reader.readUntyped();
                    continue;
                }
                if ("fileListPath".equals(fieldName)) {
                    deserializedFileServerReadSettings.fileListPath = reader.readUntyped();
                    continue;
                }
                if ("enablePartitionDiscovery".equals(fieldName)) {
                    deserializedFileServerReadSettings.enablePartitionDiscovery = reader.readUntyped();
                    continue;
                }
                if ("partitionRootPath".equals(fieldName)) {
                    deserializedFileServerReadSettings.partitionRootPath = reader.readUntyped();
                    continue;
                }
                if ("deleteFilesAfterCompletion".equals(fieldName)) {
                    deserializedFileServerReadSettings.deleteFilesAfterCompletion = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedFileServerReadSettings.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedFileServerReadSettings.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if ("fileFilter".equals(fieldName)) {
                    deserializedFileServerReadSettings.fileFilter = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedFileServerReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedFileServerReadSettings;
        });
    }
}

