/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ExposureControlRequest;
import java.io.IOException;
import java.util.List;

public final class ExposureControlBatchRequest
implements JsonSerializable<ExposureControlBatchRequest> {
    private List<ExposureControlRequest> exposureControlRequests;
    private static final ClientLogger LOGGER = new ClientLogger(ExposureControlBatchRequest.class);

    public List<ExposureControlRequest> exposureControlRequests() {
        return this.exposureControlRequests;
    }

    public ExposureControlBatchRequest withExposureControlRequests(List<ExposureControlRequest> exposureControlRequests) {
        this.exposureControlRequests = exposureControlRequests;
        return this;
    }

    public void validate() {
        if (this.exposureControlRequests() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exposureControlRequests in model ExposureControlBatchRequest"));
        }
        this.exposureControlRequests().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("exposureControlRequests", this.exposureControlRequests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExposureControlBatchRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ExposureControlBatchRequest)jsonReader.readObject(reader -> {
            ExposureControlBatchRequest deserializedExposureControlBatchRequest = new ExposureControlBatchRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exposureControlRequests".equals(fieldName)) {
                    List exposureControlRequests;
                    deserializedExposureControlBatchRequest.exposureControlRequests = exposureControlRequests = reader.readArray(reader1 -> ExposureControlRequest.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExposureControlBatchRequest;
        });
    }
}

