/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ExecutePipelineActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.ExecutePipelineActivityPolicy;
import com.azure.resourcemanager.datafactory.models.PipelineReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExecutePipelineActivity
extends ControlActivity {
    private String type = "ExecutePipeline";
    private ExecutePipelineActivityPolicy policy;
    private ExecutePipelineActivityTypeProperties innerTypeProperties = new ExecutePipelineActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ExecutePipelineActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    public ExecutePipelineActivityPolicy policy() {
        return this.policy;
    }

    public ExecutePipelineActivity withPolicy(ExecutePipelineActivityPolicy policy) {
        this.policy = policy;
        return this;
    }

    ExecutePipelineActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ExecutePipelineActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecutePipelineActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecutePipelineActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ExecutePipelineActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecutePipelineActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecutePipelineActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public PipelineReference pipeline() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pipeline();
    }

    public ExecutePipelineActivity withPipeline(PipelineReference pipeline) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withPipeline(pipeline);
        return this;
    }

    public Map<String, Object> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    public ExecutePipelineActivity withParameters(Map<String, Object> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    public Boolean waitOnCompletion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().waitOnCompletion();
    }

    public ExecutePipelineActivity withWaitOnCompletion(Boolean waitOnCompletion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withWaitOnCompletion(waitOnCompletion);
        return this;
    }

    @Override
    public void validate() {
        if (this.policy() != null) {
            this.policy().validate();
        }
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ExecutePipelineActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExecutePipelineActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecutePipelineActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutePipelineActivity)jsonReader.readObject(reader -> {
            ExecutePipelineActivity deserializedExecutePipelineActivity = new ExecutePipelineActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecutePipelineActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecutePipelineActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecutePipelineActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecutePipelineActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecutePipelineActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecutePipelineActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedExecutePipelineActivity.innerTypeProperties = ExecutePipelineActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecutePipelineActivity.type = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecutePipelineActivity.policy = ExecutePipelineActivityPolicy.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecutePipelineActivity.withAdditionalProperties(additionalProperties);
            return deserializedExecutePipelineActivity;
        });
    }
}

