/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ExecuteDataFlowActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ContinuationSettingsReference;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DataFlowStagingInfo;
import com.azure.resourcemanager.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExecuteDataFlowActivity
extends ExecutionActivity {
    private String type = "ExecuteDataFlow";
    private ExecuteDataFlowActivityTypeProperties innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteDataFlowActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    ExecuteDataFlowActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ExecuteDataFlowActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public DataFlowReference dataFlow() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataFlow();
    }

    public ExecuteDataFlowActivity withDataFlow(DataFlowReference dataFlow) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withDataFlow(dataFlow);
        return this;
    }

    public DataFlowStagingInfo staging() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().staging();
    }

    public ExecuteDataFlowActivity withStaging(DataFlowStagingInfo staging) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withStaging(staging);
        return this;
    }

    public IntegrationRuntimeReference integrationRuntime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().integrationRuntime();
    }

    public ExecuteDataFlowActivity withIntegrationRuntime(IntegrationRuntimeReference integrationRuntime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withIntegrationRuntime(integrationRuntime);
        return this;
    }

    public ContinuationSettingsReference continuationSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().continuationSettings();
    }

    public ExecuteDataFlowActivity withContinuationSettings(ContinuationSettingsReference continuationSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withContinuationSettings(continuationSettings);
        return this;
    }

    public ExecuteDataFlowActivityTypePropertiesCompute compute() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compute();
    }

    public ExecuteDataFlowActivity withCompute(ExecuteDataFlowActivityTypePropertiesCompute compute) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withCompute(compute);
        return this;
    }

    public Object traceLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().traceLevel();
    }

    public ExecuteDataFlowActivity withTraceLevel(Object traceLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withTraceLevel(traceLevel);
        return this;
    }

    public Object continueOnError() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().continueOnError();
    }

    public ExecuteDataFlowActivity withContinueOnError(Object continueOnError) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withContinueOnError(continueOnError);
        return this;
    }

    public Object runConcurrently() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runConcurrently();
    }

    public ExecuteDataFlowActivity withRunConcurrently(Object runConcurrently) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withRunConcurrently(runConcurrently);
        return this;
    }

    public Object sourceStagingConcurrency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sourceStagingConcurrency();
    }

    public ExecuteDataFlowActivity withSourceStagingConcurrency(Object sourceStagingConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteDataFlowActivityTypeProperties();
        }
        this.innerTypeProperties().withSourceStagingConcurrency(sourceStagingConcurrency);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ExecuteDataFlowActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExecuteDataFlowActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecuteDataFlowActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteDataFlowActivity)jsonReader.readObject(reader -> {
            ExecuteDataFlowActivity deserializedExecuteDataFlowActivity = new ExecuteDataFlowActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecuteDataFlowActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecuteDataFlowActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.innerTypeProperties = ExecuteDataFlowActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecuteDataFlowActivity.withAdditionalProperties(additionalProperties);
            return deserializedExecuteDataFlowActivity;
        });
    }
}

