/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.EnvironmentVariableSetupTypeProperties;
import com.azure.resourcemanager.datafactory.models.CustomSetupBase;
import java.io.IOException;

public final class EnvironmentVariableSetup
extends CustomSetupBase {
    private String type = "EnvironmentVariableSetup";
    private EnvironmentVariableSetupTypeProperties innerTypeProperties = new EnvironmentVariableSetupTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentVariableSetup.class);

    @Override
    public String type() {
        return this.type;
    }

    EnvironmentVariableSetupTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public String variableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().variableName();
    }

    public EnvironmentVariableSetup withVariableName(String variableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new EnvironmentVariableSetupTypeProperties();
        }
        this.innerTypeProperties().withVariableName(variableName);
        return this;
    }

    public String variableValue() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().variableValue();
    }

    public EnvironmentVariableSetup withVariableValue(String variableValue) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new EnvironmentVariableSetupTypeProperties();
        }
        this.innerTypeProperties().withVariableValue(variableValue);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model EnvironmentVariableSetup"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static EnvironmentVariableSetup fromJson(JsonReader jsonReader) throws IOException {
        return (EnvironmentVariableSetup)jsonReader.readObject(reader -> {
            EnvironmentVariableSetup deserializedEnvironmentVariableSetup = new EnvironmentVariableSetup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("typeProperties".equals(fieldName)) {
                    deserializedEnvironmentVariableSetup.innerTypeProperties = EnvironmentVariableSetupTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEnvironmentVariableSetup.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEnvironmentVariableSetup;
        });
    }
}

