/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CmkIdentityDefinition;
import java.io.IOException;

public final class EncryptionConfiguration
implements JsonSerializable<EncryptionConfiguration> {
    private String keyName;
    private String vaultBaseUrl;
    private String keyVersion;
    private CmkIdentityDefinition identity;
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionConfiguration.class);

    public String keyName() {
        return this.keyName;
    }

    public EncryptionConfiguration withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public EncryptionConfiguration withVaultBaseUrl(String vaultBaseUrl) {
        this.vaultBaseUrl = vaultBaseUrl;
        return this;
    }

    public String keyVersion() {
        return this.keyVersion;
    }

    public EncryptionConfiguration withKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    public CmkIdentityDefinition identity() {
        return this.identity;
    }

    public EncryptionConfiguration withIdentity(CmkIdentityDefinition identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.keyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyName in model EncryptionConfiguration"));
        }
        if (this.vaultBaseUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vaultBaseUrl in model EncryptionConfiguration"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("vaultBaseUrl", this.vaultBaseUrl);
        jsonWriter.writeStringField("keyVersion", this.keyVersion);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionConfiguration)jsonReader.readObject(reader -> {
            EncryptionConfiguration deserializedEncryptionConfiguration = new EncryptionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedEncryptionConfiguration.keyName = reader.getString();
                    continue;
                }
                if ("vaultBaseUrl".equals(fieldName)) {
                    deserializedEncryptionConfiguration.vaultBaseUrl = reader.getString();
                    continue;
                }
                if ("keyVersion".equals(fieldName)) {
                    deserializedEncryptionConfiguration.keyVersion = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedEncryptionConfiguration.identity = CmkIdentityDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionConfiguration;
        });
    }
}

