/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FormatWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DelimitedTextWriteSettings
extends FormatWriteSettings {
    private String type = "DelimitedTextWriteSettings";
    private Object quoteAllText;
    private Object fileExtension;
    private Object maxRowsPerFile;
    private Object fileNamePrefix;
    private static final ClientLogger LOGGER = new ClientLogger(DelimitedTextWriteSettings.class);

    @Override
    public String type() {
        return this.type;
    }

    public Object quoteAllText() {
        return this.quoteAllText;
    }

    public DelimitedTextWriteSettings withQuoteAllText(Object quoteAllText) {
        this.quoteAllText = quoteAllText;
        return this;
    }

    public Object fileExtension() {
        return this.fileExtension;
    }

    public DelimitedTextWriteSettings withFileExtension(Object fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    public Object maxRowsPerFile() {
        return this.maxRowsPerFile;
    }

    public DelimitedTextWriteSettings withMaxRowsPerFile(Object maxRowsPerFile) {
        this.maxRowsPerFile = maxRowsPerFile;
        return this;
    }

    public Object fileNamePrefix() {
        return this.fileNamePrefix;
    }

    public DelimitedTextWriteSettings withFileNamePrefix(Object fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        return this;
    }

    @Override
    public void validate() {
        if (this.fileExtension() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fileExtension in model DelimitedTextWriteSettings"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("fileExtension", this.fileExtension);
        jsonWriter.writeStringField("type", this.type);
        if (this.quoteAllText != null) {
            jsonWriter.writeUntypedField("quoteAllText", this.quoteAllText);
        }
        if (this.maxRowsPerFile != null) {
            jsonWriter.writeUntypedField("maxRowsPerFile", this.maxRowsPerFile);
        }
        if (this.fileNamePrefix != null) {
            jsonWriter.writeUntypedField("fileNamePrefix", this.fileNamePrefix);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DelimitedTextWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DelimitedTextWriteSettings)jsonReader.readObject(reader -> {
            DelimitedTextWriteSettings deserializedDelimitedTextWriteSettings = new DelimitedTextWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileExtension".equals(fieldName)) {
                    deserializedDelimitedTextWriteSettings.fileExtension = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDelimitedTextWriteSettings.type = reader.getString();
                    continue;
                }
                if ("quoteAllText".equals(fieldName)) {
                    deserializedDelimitedTextWriteSettings.quoteAllText = reader.readUntyped();
                    continue;
                }
                if ("maxRowsPerFile".equals(fieldName)) {
                    deserializedDelimitedTextWriteSettings.maxRowsPerFile = reader.readUntyped();
                    continue;
                }
                if ("fileNamePrefix".equals(fieldName)) {
                    deserializedDelimitedTextWriteSettings.fileNamePrefix = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDelimitedTextWriteSettings.withAdditionalProperties(additionalProperties);
            return deserializedDelimitedTextWriteSettings;
        });
    }
}

