/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.DynamicsSinkWriteBehavior;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CommonDataServiceForAppsSink
extends CopySink {
    private String type = "CommonDataServiceForAppsSink";
    private DynamicsSinkWriteBehavior writeBehavior;
    private Object ignoreNullValues;
    private Object alternateKeyName;
    private Object bypassBusinessLogicExecution;
    private Object bypassPowerAutomateFlows;
    private static final ClientLogger LOGGER = new ClientLogger(CommonDataServiceForAppsSink.class);

    @Override
    public String type() {
        return this.type;
    }

    public DynamicsSinkWriteBehavior writeBehavior() {
        return this.writeBehavior;
    }

    public CommonDataServiceForAppsSink withWriteBehavior(DynamicsSinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object ignoreNullValues() {
        return this.ignoreNullValues;
    }

    public CommonDataServiceForAppsSink withIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    public Object alternateKeyName() {
        return this.alternateKeyName;
    }

    public CommonDataServiceForAppsSink withAlternateKeyName(Object alternateKeyName) {
        this.alternateKeyName = alternateKeyName;
        return this;
    }

    public Object bypassBusinessLogicExecution() {
        return this.bypassBusinessLogicExecution;
    }

    public CommonDataServiceForAppsSink withBypassBusinessLogicExecution(Object bypassBusinessLogicExecution) {
        this.bypassBusinessLogicExecution = bypassBusinessLogicExecution;
        return this;
    }

    public Object bypassPowerAutomateFlows() {
        return this.bypassPowerAutomateFlows;
    }

    public CommonDataServiceForAppsSink withBypassPowerAutomateFlows(Object bypassPowerAutomateFlows) {
        this.bypassPowerAutomateFlows = bypassPowerAutomateFlows;
        return this;
    }

    @Override
    public CommonDataServiceForAppsSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public CommonDataServiceForAppsSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public CommonDataServiceForAppsSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public CommonDataServiceForAppsSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public CommonDataServiceForAppsSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public CommonDataServiceForAppsSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.writeBehavior() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property writeBehavior in model CommonDataServiceForAppsSink"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        jsonWriter.writeStringField("type", this.type);
        if (this.ignoreNullValues != null) {
            jsonWriter.writeUntypedField("ignoreNullValues", this.ignoreNullValues);
        }
        if (this.alternateKeyName != null) {
            jsonWriter.writeUntypedField("alternateKeyName", this.alternateKeyName);
        }
        if (this.bypassBusinessLogicExecution != null) {
            jsonWriter.writeUntypedField("bypassBusinessLogicExecution", this.bypassBusinessLogicExecution);
        }
        if (this.bypassPowerAutomateFlows != null) {
            jsonWriter.writeUntypedField("bypassPowerAutomateFlows", this.bypassPowerAutomateFlows);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CommonDataServiceForAppsSink fromJson(JsonReader jsonReader) throws IOException {
        return (CommonDataServiceForAppsSink)jsonReader.readObject(reader -> {
            CommonDataServiceForAppsSink deserializedCommonDataServiceForAppsSink = new CommonDataServiceForAppsSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.writeBehavior = DynamicsSinkWriteBehavior.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.type = reader.getString();
                    continue;
                }
                if ("ignoreNullValues".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.ignoreNullValues = reader.readUntyped();
                    continue;
                }
                if ("alternateKeyName".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.alternateKeyName = reader.readUntyped();
                    continue;
                }
                if ("bypassBusinessLogicExecution".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.bypassBusinessLogicExecution = reader.readUntyped();
                    continue;
                }
                if ("bypassPowerAutomateFlows".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsSink.bypassPowerAutomateFlows = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCommonDataServiceForAppsSink.withAdditionalProperties(additionalProperties);
            return deserializedCommonDataServiceForAppsSink;
        });
    }
}

