/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ChainingTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.PipelineReference;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ChainingTrigger
extends Trigger {
    private String type = "ChainingTrigger";
    private TriggerPipelineReference pipeline;
    private ChainingTriggerTypeProperties innerTypeProperties = new ChainingTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ChainingTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    public TriggerPipelineReference pipeline() {
        return this.pipeline;
    }

    public ChainingTrigger withPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    ChainingTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ChainingTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ChainingTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public List<PipelineReference> dependsOn() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dependsOn();
    }

    public ChainingTrigger withDependsOn(List<PipelineReference> dependsOn) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ChainingTriggerTypeProperties();
        }
        this.innerTypeProperties().withDependsOn(dependsOn);
        return this;
    }

    public String runDimension() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runDimension();
    }

    public ChainingTrigger withRunDimension(String runDimension) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ChainingTriggerTypeProperties();
        }
        this.innerTypeProperties().withRunDimension(runDimension);
        return this;
    }

    @Override
    public void validate() {
        if (this.pipeline() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property pipeline in model ChainingTrigger"));
        }
        this.pipeline().validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ChainingTrigger"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("pipeline", (JsonSerializable)this.pipeline);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ChainingTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (ChainingTrigger)jsonReader.readObject(reader -> {
            ChainingTrigger deserializedChainingTrigger = new ChainingTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedChainingTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedChainingTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedChainingTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("pipeline".equals(fieldName)) {
                    deserializedChainingTrigger.pipeline = TriggerPipelineReference.fromJson(reader);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedChainingTrigger.innerTypeProperties = ChainingTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChainingTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedChainingTrigger.withAdditionalProperties(additionalProperties);
            return deserializedChainingTrigger;
        });
    }
}

