/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureStorageLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureStorageLinkedService
extends LinkedService {
    private String type = "AzureStorage";
    private AzureStorageLinkedServiceTypeProperties innerTypeProperties = new AzureStorageLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureStorageLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureStorageLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureStorageLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureStorageLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureStorageLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureStorageLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureStorageLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public AzureStorageLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public AzureKeyVaultSecretReference accountKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountKey();
    }

    public AzureStorageLinkedService withAccountKey(AzureKeyVaultSecretReference accountKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountKey(accountKey);
        return this;
    }

    public Object sasUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sasUri();
    }

    public AzureStorageLinkedService withSasUri(Object sasUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSasUri(sasUri);
        return this;
    }

    public AzureKeyVaultSecretReference sasToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sasToken();
    }

    public AzureStorageLinkedService withSasToken(AzureKeyVaultSecretReference sasToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSasToken(sasToken);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureStorageLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureStorageLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureStorageLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureStorageLinkedService)jsonReader.readObject(reader -> {
            AzureStorageLinkedService deserializedAzureStorageLinkedService = new AzureStorageLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureStorageLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureStorageLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureStorageLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureStorageLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureStorageLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureStorageLinkedService.innerTypeProperties = AzureStorageLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureStorageLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureStorageLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureStorageLinkedService;
        });
    }
}

