/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class AzureMLWebServiceFile
implements JsonSerializable<AzureMLWebServiceFile> {
    private Object filePath;
    private LinkedServiceReference linkedServiceName;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLWebServiceFile.class);

    public Object filePath() {
        return this.filePath;
    }

    public AzureMLWebServiceFile withFilePath(Object filePath) {
        this.filePath = filePath;
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public AzureMLWebServiceFile withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public void validate() {
        if (this.filePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filePath in model AzureMLWebServiceFile"));
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model AzureMLWebServiceFile"));
        }
        this.linkedServiceName().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("filePath", this.filePath);
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        return jsonWriter.writeEndObject();
    }

    public static AzureMLWebServiceFile fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLWebServiceFile)jsonReader.readObject(reader -> {
            AzureMLWebServiceFile deserializedAzureMLWebServiceFile = new AzureMLWebServiceFile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filePath".equals(fieldName)) {
                    deserializedAzureMLWebServiceFile.filePath = reader.readUntyped();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureMLWebServiceFile.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMLWebServiceFile;
        });
    }
}

