/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureMLBatchExecutionActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.AzureMLWebServiceFile;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureMLBatchExecutionActivity
extends ExecutionActivity {
    private String type = "AzureMLBatchExecution";
    private AzureMLBatchExecutionActivityTypeProperties innerTypeProperties = new AzureMLBatchExecutionActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLBatchExecutionActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureMLBatchExecutionActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureMLBatchExecutionActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Map<String, Object> globalParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().globalParameters();
    }

    public AzureMLBatchExecutionActivity withGlobalParameters(Map<String, Object> globalParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLBatchExecutionActivityTypeProperties();
        }
        this.innerTypeProperties().withGlobalParameters(globalParameters);
        return this;
    }

    public Map<String, AzureMLWebServiceFile> webServiceOutputs() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().webServiceOutputs();
    }

    public AzureMLBatchExecutionActivity withWebServiceOutputs(Map<String, AzureMLWebServiceFile> webServiceOutputs) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLBatchExecutionActivityTypeProperties();
        }
        this.innerTypeProperties().withWebServiceOutputs(webServiceOutputs);
        return this;
    }

    public Map<String, AzureMLWebServiceFile> webServiceInputs() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().webServiceInputs();
    }

    public AzureMLBatchExecutionActivity withWebServiceInputs(Map<String, AzureMLWebServiceFile> webServiceInputs) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLBatchExecutionActivityTypeProperties();
        }
        this.innerTypeProperties().withWebServiceInputs(webServiceInputs);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureMLBatchExecutionActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AzureMLBatchExecutionActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMLBatchExecutionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLBatchExecutionActivity)jsonReader.readObject(reader -> {
            AzureMLBatchExecutionActivity deserializedAzureMLBatchExecutionActivity = new AzureMLBatchExecutionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureMLBatchExecutionActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureMLBatchExecutionActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.innerTypeProperties = AzureMLBatchExecutionActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMLBatchExecutionActivity.withAdditionalProperties(additionalProperties);
            return deserializedAzureMLBatchExecutionActivity;
        });
    }
}

