/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureDataLakeStoreLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureDataLakeStoreLinkedService
extends LinkedService {
    private String type = "AzureDataLakeStore";
    private AzureDataLakeStoreLinkedServiceTypeProperties innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureDataLakeStoreLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureDataLakeStoreLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureDataLakeStoreLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureDataLakeStoreLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureDataLakeStoreLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureDataLakeStoreLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureDataLakeStoreLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object dataLakeStoreUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataLakeStoreUri();
    }

    public AzureDataLakeStoreLinkedService withDataLakeStoreUri(Object dataLakeStoreUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDataLakeStoreUri(dataLakeStoreUri);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public AzureDataLakeStoreLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public AzureDataLakeStoreLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public AzureDataLakeStoreLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    public Object azureCloudType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().azureCloudType();
    }

    public AzureDataLakeStoreLinkedService withAzureCloudType(Object azureCloudType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAzureCloudType(azureCloudType);
        return this;
    }

    public Object accountName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountName();
    }

    public AzureDataLakeStoreLinkedService withAccountName(Object accountName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountName(accountName);
        return this;
    }

    public Object subscriptionId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().subscriptionId();
    }

    public AzureDataLakeStoreLinkedService withSubscriptionId(Object subscriptionId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSubscriptionId(subscriptionId);
        return this;
    }

    public Object resourceGroupName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceGroupName();
    }

    public AzureDataLakeStoreLinkedService withResourceGroupName(Object resourceGroupName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withResourceGroupName(resourceGroupName);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureDataLakeStoreLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureDataLakeStoreLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureDataLakeStoreLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeStoreLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeStoreLinkedService)jsonReader.readObject(reader -> {
            AzureDataLakeStoreLinkedService deserializedAzureDataLakeStoreLinkedService = new AzureDataLakeStoreLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDataLakeStoreLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDataLakeStoreLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedService.innerTypeProperties = AzureDataLakeStoreLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataLakeStoreLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureDataLakeStoreLinkedService;
        });
    }
}

