/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.RedshiftUnloadSettings;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonRedshiftSource
extends TabularSource {
    private String type = "AmazonRedshiftSource";
    private Object query;
    private RedshiftUnloadSettings redshiftUnloadSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public AmazonRedshiftSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public RedshiftUnloadSettings redshiftUnloadSettings() {
        return this.redshiftUnloadSettings;
    }

    public AmazonRedshiftSource withRedshiftUnloadSettings(RedshiftUnloadSettings redshiftUnloadSettings) {
        this.redshiftUnloadSettings = redshiftUnloadSettings;
        return this;
    }

    @Override
    public AmazonRedshiftSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public AmazonRedshiftSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public AmazonRedshiftSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AmazonRedshiftSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AmazonRedshiftSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AmazonRedshiftSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.redshiftUnloadSettings() != null) {
            this.redshiftUnloadSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.queryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        }
        if (this.additionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        jsonWriter.writeJsonField("redshiftUnloadSettings", (JsonSerializable)this.redshiftUnloadSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRedshiftSource fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRedshiftSource)jsonReader.readObject(reader -> {
            AmazonRedshiftSource deserializedAmazonRedshiftSource = new AmazonRedshiftSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.query = reader.readUntyped();
                    continue;
                }
                if ("redshiftUnloadSettings".equals(fieldName)) {
                    deserializedAmazonRedshiftSource.redshiftUnloadSettings = RedshiftUnloadSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRedshiftSource.withAdditionalProperties(additionalProperties);
            return deserializedAmazonRedshiftSource;
        });
    }
}

