/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SqlPartitionSettings;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonRdsForSqlServerSource
extends TabularSource {
    private String type = "AmazonRdsForSqlServerSource";
    private Object sqlReaderQuery;
    private Object sqlReaderStoredProcedureName;
    private Object storedProcedureParameters;
    private Object isolationLevel;
    private Object produceAdditionalTypes;
    private Object partitionOption;
    private SqlPartitionSettings partitionSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object sqlReaderQuery() {
        return this.sqlReaderQuery;
    }

    public AmazonRdsForSqlServerSource withSqlReaderQuery(Object sqlReaderQuery) {
        this.sqlReaderQuery = sqlReaderQuery;
        return this;
    }

    public Object sqlReaderStoredProcedureName() {
        return this.sqlReaderStoredProcedureName;
    }

    public AmazonRdsForSqlServerSource withSqlReaderStoredProcedureName(Object sqlReaderStoredProcedureName) {
        this.sqlReaderStoredProcedureName = sqlReaderStoredProcedureName;
        return this;
    }

    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public AmazonRdsForSqlServerSource withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object isolationLevel() {
        return this.isolationLevel;
    }

    public AmazonRdsForSqlServerSource withIsolationLevel(Object isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public Object produceAdditionalTypes() {
        return this.produceAdditionalTypes;
    }

    public AmazonRdsForSqlServerSource withProduceAdditionalTypes(Object produceAdditionalTypes) {
        this.produceAdditionalTypes = produceAdditionalTypes;
        return this;
    }

    public Object partitionOption() {
        return this.partitionOption;
    }

    public AmazonRdsForSqlServerSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SqlPartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    public AmazonRdsForSqlServerSource withPartitionSettings(SqlPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.partitionSettings() != null) {
            this.partitionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.queryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        }
        if (this.additionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.sqlReaderQuery != null) {
            jsonWriter.writeUntypedField("sqlReaderQuery", this.sqlReaderQuery);
        }
        if (this.sqlReaderStoredProcedureName != null) {
            jsonWriter.writeUntypedField("sqlReaderStoredProcedureName", this.sqlReaderStoredProcedureName);
        }
        if (this.storedProcedureParameters != null) {
            jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        }
        if (this.isolationLevel != null) {
            jsonWriter.writeUntypedField("isolationLevel", this.isolationLevel);
        }
        if (this.produceAdditionalTypes != null) {
            jsonWriter.writeUntypedField("produceAdditionalTypes", this.produceAdditionalTypes);
        }
        if (this.partitionOption != null) {
            jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        }
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForSqlServerSource fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForSqlServerSource)jsonReader.readObject(reader -> {
            AmazonRdsForSqlServerSource deserializedAmazonRdsForSqlServerSource = new AmazonRdsForSqlServerSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.type = reader.getString();
                    continue;
                }
                if ("sqlReaderQuery".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.sqlReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("sqlReaderStoredProcedureName".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.sqlReaderStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("isolationLevel".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.isolationLevel = reader.readUntyped();
                    continue;
                }
                if ("produceAdditionalTypes".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.produceAdditionalTypes = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.partitionSettings = SqlPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRdsForSqlServerSource.withAdditionalProperties(additionalProperties);
            return deserializedAmazonRdsForSqlServerSource;
        });
    }
}

