/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonRdsForLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AmazonRdsForOracleAuthenticationType;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AmazonRdsForOracleLinkedService
extends LinkedService {
    private String type = "AmazonRdsForOracle";
    private AmazonRdsForLinkedServiceTypeProperties innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AmazonRdsForOracleLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AmazonRdsForLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AmazonRdsForOracleLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AmazonRdsForOracleLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AmazonRdsForOracleLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AmazonRdsForOracleLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AmazonRdsForOracleLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public AmazonRdsForOracleLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public AmazonRdsForOracleLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public AmazonRdsForOracleAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public AmazonRdsForOracleLinkedService withAuthenticationType(AmazonRdsForOracleAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public AmazonRdsForOracleLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public AmazonRdsForOracleLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object encryptionClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptionClient();
    }

    public AmazonRdsForOracleLinkedService withEncryptionClient(Object encryptionClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptionClient(encryptionClient);
        return this;
    }

    public Object encryptionTypesClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptionTypesClient();
    }

    public AmazonRdsForOracleLinkedService withEncryptionTypesClient(Object encryptionTypesClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptionTypesClient(encryptionTypesClient);
        return this;
    }

    public Object cryptoChecksumClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().cryptoChecksumClient();
    }

    public AmazonRdsForOracleLinkedService withCryptoChecksumClient(Object cryptoChecksumClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCryptoChecksumClient(cryptoChecksumClient);
        return this;
    }

    public Object cryptoChecksumTypesClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().cryptoChecksumTypesClient();
    }

    public AmazonRdsForOracleLinkedService withCryptoChecksumTypesClient(Object cryptoChecksumTypesClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCryptoChecksumTypesClient(cryptoChecksumTypesClient);
        return this;
    }

    public Object initialLobFetchSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().initialLobFetchSize();
    }

    public AmazonRdsForOracleLinkedService withInitialLobFetchSize(Object initialLobFetchSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withInitialLobFetchSize(initialLobFetchSize);
        return this;
    }

    public Object fetchSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fetchSize();
    }

    public AmazonRdsForOracleLinkedService withFetchSize(Object fetchSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFetchSize(fetchSize);
        return this;
    }

    public Object statementCacheSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().statementCacheSize();
    }

    public AmazonRdsForOracleLinkedService withStatementCacheSize(Object statementCacheSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withStatementCacheSize(statementCacheSize);
        return this;
    }

    public Object initializationString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().initializationString();
    }

    public AmazonRdsForOracleLinkedService withInitializationString(Object initializationString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withInitializationString(initializationString);
        return this;
    }

    public Object enableBulkLoad() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableBulkLoad();
    }

    public AmazonRdsForOracleLinkedService withEnableBulkLoad(Object enableBulkLoad) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableBulkLoad(enableBulkLoad);
        return this;
    }

    public Object supportV1DataTypes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().supportV1DataTypes();
    }

    public AmazonRdsForOracleLinkedService withSupportV1DataTypes(Object supportV1DataTypes) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSupportV1DataTypes(supportV1DataTypes);
        return this;
    }

    public Object fetchTswtzAsTimestamp() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fetchTswtzAsTimestamp();
    }

    public AmazonRdsForOracleLinkedService withFetchTswtzAsTimestamp(Object fetchTswtzAsTimestamp) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFetchTswtzAsTimestamp(fetchTswtzAsTimestamp);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AmazonRdsForOracleLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AmazonRdsForOracleLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForOracleLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForOracleLinkedService)jsonReader.readObject(reader -> {
            AmazonRdsForOracleLinkedService deserializedAmazonRdsForOracleLinkedService = new AmazonRdsForOracleLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAmazonRdsForOracleLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAmazonRdsForOracleLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonRdsForOracleLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonRdsForOracleLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonRdsForOracleLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAmazonRdsForOracleLinkedService.innerTypeProperties = AmazonRdsForLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRdsForOracleLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRdsForOracleLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAmazonRdsForOracleLinkedService;
        });
    }
}

