/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.AppendVariableActivity;
import com.azure.resourcemanager.datafactory.models.AzureDataExplorerCommandActivity;
import com.azure.resourcemanager.datafactory.models.AzureFunctionActivity;
import com.azure.resourcemanager.datafactory.models.AzureMLBatchExecutionActivity;
import com.azure.resourcemanager.datafactory.models.AzureMLExecutePipelineActivity;
import com.azure.resourcemanager.datafactory.models.AzureMLUpdateResourceActivity;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.CopyActivity;
import com.azure.resourcemanager.datafactory.models.CustomActivity;
import com.azure.resourcemanager.datafactory.models.DataLakeAnalyticsUsqlActivity;
import com.azure.resourcemanager.datafactory.models.DatabricksNotebookActivity;
import com.azure.resourcemanager.datafactory.models.DatabricksSparkJarActivity;
import com.azure.resourcemanager.datafactory.models.DatabricksSparkPythonActivity;
import com.azure.resourcemanager.datafactory.models.DeleteActivity;
import com.azure.resourcemanager.datafactory.models.ExecuteDataFlowActivity;
import com.azure.resourcemanager.datafactory.models.ExecutePipelineActivity;
import com.azure.resourcemanager.datafactory.models.ExecuteSsisPackageActivity;
import com.azure.resourcemanager.datafactory.models.ExecuteWranglingDataflowActivity;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.FailActivity;
import com.azure.resourcemanager.datafactory.models.FilterActivity;
import com.azure.resourcemanager.datafactory.models.ForEachActivity;
import com.azure.resourcemanager.datafactory.models.GetMetadataActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightHiveActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightMapReduceActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightPigActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightSparkActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightStreamingActivity;
import com.azure.resourcemanager.datafactory.models.IfConditionActivity;
import com.azure.resourcemanager.datafactory.models.LookupActivity;
import com.azure.resourcemanager.datafactory.models.ScriptActivity;
import com.azure.resourcemanager.datafactory.models.SetVariableActivity;
import com.azure.resourcemanager.datafactory.models.SqlServerStoredProcedureActivity;
import com.azure.resourcemanager.datafactory.models.SwitchActivity;
import com.azure.resourcemanager.datafactory.models.SynapseNotebookActivity;
import com.azure.resourcemanager.datafactory.models.SynapseSparkJobDefinitionActivity;
import com.azure.resourcemanager.datafactory.models.UntilActivity;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.azure.resourcemanager.datafactory.models.ValidationActivity;
import com.azure.resourcemanager.datafactory.models.WaitActivity;
import com.azure.resourcemanager.datafactory.models.WebActivity;
import com.azure.resourcemanager.datafactory.models.WebhookActivity;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Activity
implements JsonSerializable<Activity> {
    private String type = "Activity";
    private String name;
    private String description;
    private ActivityState state;
    private ActivityOnInactiveMarkAs onInactiveMarkAs;
    private List<ActivityDependency> dependsOn;
    private List<UserProperty> userProperties;
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(Activity.class);

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public Activity withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Activity withDescription(String description) {
        this.description = description;
        return this;
    }

    public ActivityState state() {
        return this.state;
    }

    public Activity withState(ActivityState state) {
        this.state = state;
        return this;
    }

    public ActivityOnInactiveMarkAs onInactiveMarkAs() {
        return this.onInactiveMarkAs;
    }

    public Activity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        this.onInactiveMarkAs = onInactiveMarkAs;
        return this;
    }

    public List<ActivityDependency> dependsOn() {
        return this.dependsOn;
    }

    public Activity withDependsOn(List<ActivityDependency> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public List<UserProperty> userProperties() {
        return this.userProperties;
    }

    public Activity withUserProperties(List<UserProperty> userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public Activity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Activity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs == null ? null : this.onInactiveMarkAs.toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Activity fromJson(JsonReader jsonReader) throws IOException {
        return (Activity)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Activity activity;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Container".equals(discriminatorValue)) {
                    activity = ControlActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                    return activity;
                }
                if ("ExecutePipeline".equals(discriminatorValue)) {
                    activity = ExecutePipelineActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("IfCondition".equals(discriminatorValue)) {
                    activity = IfConditionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Switch".equals(discriminatorValue)) {
                    activity = SwitchActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ForEach".equals(discriminatorValue)) {
                    activity = ForEachActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Wait".equals(discriminatorValue)) {
                    activity = WaitActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Fail".equals(discriminatorValue)) {
                    activity = FailActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Until".equals(discriminatorValue)) {
                    activity = UntilActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Validation".equals(discriminatorValue)) {
                    activity = ValidationActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Filter".equals(discriminatorValue)) {
                    activity = FilterActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SetVariable".equals(discriminatorValue)) {
                    activity = SetVariableActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AppendVariable".equals(discriminatorValue)) {
                    activity = AppendVariableActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("WebHook".equals(discriminatorValue)) {
                    activity = WebhookActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Execution".equals(discriminatorValue)) {
                    activity = ExecutionActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                    return activity;
                }
                if ("Copy".equals(discriminatorValue)) {
                    activity = CopyActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightHive".equals(discriminatorValue)) {
                    activity = HDInsightHiveActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightPig".equals(discriminatorValue)) {
                    activity = HDInsightPigActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightMapReduce".equals(discriminatorValue)) {
                    activity = HDInsightMapReduceActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightStreaming".equals(discriminatorValue)) {
                    activity = HDInsightStreamingActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightSpark".equals(discriminatorValue)) {
                    activity = HDInsightSparkActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ExecuteSSISPackage".equals(discriminatorValue)) {
                    activity = ExecuteSsisPackageActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Custom".equals(discriminatorValue)) {
                    activity = CustomActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SqlServerStoredProcedure".equals(discriminatorValue)) {
                    activity = SqlServerStoredProcedureActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Delete".equals(discriminatorValue)) {
                    activity = DeleteActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureDataExplorerCommand".equals(discriminatorValue)) {
                    activity = AzureDataExplorerCommandActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Lookup".equals(discriminatorValue)) {
                    activity = LookupActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("WebActivity".equals(discriminatorValue)) {
                    activity = WebActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("GetMetadata".equals(discriminatorValue)) {
                    activity = GetMetadataActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureMLBatchExecution".equals(discriminatorValue)) {
                    activity = AzureMLBatchExecutionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureMLUpdateResource".equals(discriminatorValue)) {
                    activity = AzureMLUpdateResourceActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureMLExecutePipeline".equals(discriminatorValue)) {
                    activity = AzureMLExecutePipelineActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DataLakeAnalyticsU-SQL".equals(discriminatorValue)) {
                    activity = DataLakeAnalyticsUsqlActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DatabricksNotebook".equals(discriminatorValue)) {
                    activity = DatabricksNotebookActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DatabricksSparkJar".equals(discriminatorValue)) {
                    activity = DatabricksSparkJarActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DatabricksSparkPython".equals(discriminatorValue)) {
                    activity = DatabricksSparkPythonActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureFunctionActivity".equals(discriminatorValue)) {
                    activity = AzureFunctionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ExecuteDataFlow".equals(discriminatorValue)) {
                    activity = ExecuteDataFlowActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Script".equals(discriminatorValue)) {
                    activity = ScriptActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SynapseNotebook".equals(discriminatorValue)) {
                    activity = SynapseNotebookActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SparkJob".equals(discriminatorValue)) {
                    activity = SynapseSparkJobDefinitionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ExecuteWranglingDataflow".equals(discriminatorValue)) {
                    activity = ExecuteWranglingDataflowActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                activity = Activity.fromJsonKnownDiscriminator(readerToUse.reset());
                return activity;
            }
        });
    }

    static Activity fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Activity)jsonReader.readObject(reader -> {
            Activity deserializedActivity = new Activity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedActivity.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedActivity.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedActivity.description = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedActivity.state = ActivityState.fromString(reader.getString());
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedActivity.onInactiveMarkAs = ActivityOnInactiveMarkAs.fromString(reader.getString());
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedActivity.dependsOn = dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties;
                    deserializedActivity.userProperties = userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivity.additionalProperties = additionalProperties;
            return deserializedActivity;
        });
    }
}

