/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.TriggerRunsClient;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerRunsQueryResponseInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.RunFilterParameters;
import reactor.core.publisher.Mono;

public final class TriggerRunsClientImpl
implements TriggerRunsClient {
    private final TriggerRunsService service;
    private final DataFactoryManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(TriggerRunsClientImpl.class);

    TriggerRunsClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (TriggerRunsService)RestProxy.create(TriggerRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> rerunWithResponseAsync(String resourceGroupName, String factoryName, String triggerName, String runId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (runId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.rerun(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, triggerName, runId, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> rerunAsync(String resourceGroupName, String factoryName, String triggerName, String runId) {
        return this.rerunWithResponseAsync(resourceGroupName, factoryName, triggerName, runId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rerunWithResponse(String resourceGroupName, String factoryName, String triggerName, String runId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (triggerName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (runId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter runId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.rerunSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, triggerName, runId, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rerun(String resourceGroupName, String factoryName, String triggerName, String runId) {
        this.rerunWithResponse(resourceGroupName, factoryName, triggerName, runId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String factoryName, String triggerName, String runId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (runId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, triggerName, runId, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> cancelAsync(String resourceGroupName, String factoryName, String triggerName, String runId) {
        return this.cancelWithResponseAsync(resourceGroupName, factoryName, triggerName, runId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String resourceGroupName, String factoryName, String triggerName, String runId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (triggerName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (runId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter runId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.cancelSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, triggerName, runId, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String factoryName, String triggerName, String runId) {
        this.cancelWithResponse(resourceGroupName, factoryName, triggerName, runId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TriggerRunsQueryResponseInner>> queryByFactoryWithResponseAsync(String resourceGroupName, String factoryName, RunFilterParameters filterParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (filterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filterParameters is required and cannot be null."));
        }
        filterParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), filterParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TriggerRunsQueryResponseInner> queryByFactoryAsync(String resourceGroupName, String factoryName, RunFilterParameters filterParameters) {
        return this.queryByFactoryWithResponseAsync(resourceGroupName, factoryName, filterParameters).flatMap(res -> Mono.justOrEmpty((Object)((TriggerRunsQueryResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerRunsQueryResponseInner> queryByFactoryWithResponse(String resourceGroupName, String factoryName, RunFilterParameters filterParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (filterParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter filterParameters is required and cannot be null."));
        }
        filterParameters.validate();
        String accept = "application/json";
        return this.service.queryByFactorySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), filterParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerRunsQueryResponseInner queryByFactory(String resourceGroupName, String factoryName, RunFilterParameters filterParameters) {
        return (TriggerRunsQueryResponseInner)this.queryByFactoryWithResponse(resourceGroupName, factoryName, filterParameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface TriggerRunsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/triggerRuns/{runId}/rerun")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> rerun(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="triggerName") String var5, @PathParam(value="runId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/triggerRuns/{runId}/rerun")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> rerunSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="triggerName") String var5, @PathParam(value="runId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/triggerRuns/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="triggerName") String var5, @PathParam(value="runId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/triggerRuns/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> cancelSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="triggerName") String var5, @PathParam(value="runId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/queryTriggerRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TriggerRunsQueryResponseInner>> queryByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RunFilterParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/queryTriggerRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TriggerRunsQueryResponseInner> queryByFactorySync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RunFilterParameters var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

