/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.PipelinesClient;
import com.azure.resourcemanager.datafactory.fluent.models.CreateRunResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineResourceInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.PipelineListResponse;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class PipelinesClientImpl
implements PipelinesClient {
    private final PipelinesService service;
    private final DataFactoryManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(PipelinesClientImpl.class);

    PipelinesClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (PipelinesService)RestProxy.create(PipelinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PipelineResourceInner>> listByFactorySinglePageAsync(String resourceGroupName, String factoryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).value(), ((PipelineListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PipelineResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName) {
        return new PagedFlux(() -> this.listByFactorySinglePageAsync(resourceGroupName, factoryName), nextLink -> this.listByFactoryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PipelineResourceInner> listByFactorySinglePage(String resourceGroupName, String factoryName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PipelineListResponse> res = this.service.listByFactorySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).value(), ((PipelineListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PipelineResourceInner> listByFactorySinglePage(String resourceGroupName, String factoryName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PipelineListResponse> res = this.service.listByFactorySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).value(), ((PipelineListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PipelineResourceInner> listByFactory(String resourceGroupName, String factoryName) {
        return new PagedIterable(() -> this.listByFactorySinglePage(resourceGroupName, factoryName), nextLink -> this.listByFactoryNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PipelineResourceInner> listByFactory(String resourceGroupName, String factoryName, Context context) {
        return new PagedIterable(() -> this.listByFactorySinglePage(resourceGroupName, factoryName, context), nextLink -> this.listByFactoryNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PipelineResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String factoryName, String pipelineName, PipelineResourceInner pipeline, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        if (pipeline == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pipeline is required and cannot be null."));
        }
        pipeline.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), ifMatch, pipeline, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PipelineResourceInner> createOrUpdateAsync(String resourceGroupName, String factoryName, String pipelineName, PipelineResourceInner pipeline) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, factoryName, pipelineName, pipeline, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PipelineResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName, String pipelineName, PipelineResourceInner pipeline, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        if (pipeline == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter pipeline is required and cannot be null."));
        }
        pipeline.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), ifMatch, pipeline, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResourceInner createOrUpdate(String resourceGroupName, String factoryName, String pipelineName, PipelineResourceInner pipeline) {
        String ifMatch = null;
        return (PipelineResourceInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, factoryName, pipelineName, pipeline, ifMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PipelineResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String pipelineName, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PipelineResourceInner> getAsync(String resourceGroupName, String factoryName, String pipelineName) {
        String ifNoneMatch = null;
        return this.getWithResponseAsync(resourceGroupName, factoryName, pipelineName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PipelineResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineResourceInner> getWithResponse(String resourceGroupName, String factoryName, String pipelineName, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), ifNoneMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResourceInner get(String resourceGroupName, String factoryName, String pipelineName) {
        String ifNoneMatch = null;
        return (PipelineResourceInner)((Object)this.getWithResponse(resourceGroupName, factoryName, pipelineName, ifNoneMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName, String pipelineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String pipelineName) {
        return this.deleteWithResponseAsync(resourceGroupName, factoryName, pipelineName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String pipelineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String pipelineName) {
        this.deleteWithResponse(resourceGroupName, factoryName, pipelineName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CreateRunResponseInner>> createRunWithResponseAsync(String resourceGroupName, String factoryName, String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Boolean startFromFailure, Map<String, Object> parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRun(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), referencePipelineRunId, isRecovery, startActivityName, startFromFailure, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CreateRunResponseInner> createRunAsync(String resourceGroupName, String factoryName, String pipelineName) {
        String referencePipelineRunId = null;
        Boolean isRecovery = null;
        String startActivityName = null;
        Boolean startFromFailure = null;
        Map<String, Object> parameters = null;
        return this.createRunWithResponseAsync(resourceGroupName, factoryName, pipelineName, referencePipelineRunId, isRecovery, startActivityName, startFromFailure, parameters).flatMap(res -> Mono.justOrEmpty((Object)((CreateRunResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateRunResponseInner> createRunWithResponse(String resourceGroupName, String factoryName, String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Boolean startFromFailure, Map<String, Object> parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.createRunSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), referencePipelineRunId, isRecovery, startActivityName, startFromFailure, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateRunResponseInner createRun(String resourceGroupName, String factoryName, String pipelineName) {
        String referencePipelineRunId = null;
        Boolean isRecovery = null;
        String startActivityName = null;
        Boolean startFromFailure = null;
        Map<String, Object> parameters = null;
        return (CreateRunResponseInner)this.createRunWithResponse(resourceGroupName, factoryName, pipelineName, referencePipelineRunId, isRecovery, startActivityName, startFromFailure, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PipelineResourceInner>> listByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactoryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).value(), ((PipelineListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PipelineResourceInner> listByFactoryNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PipelineListResponse> res = this.service.listByFactoryNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).value(), ((PipelineListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PipelineResourceInner> listByFactoryNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PipelineListResponse> res = this.service.listByFactoryNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).value(), ((PipelineListResponse)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface PipelinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PipelineListResponse>> listByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PipelineListResponse> listByFactorySync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PipelineResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") PipelineResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PipelineResourceInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") PipelineResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PipelineResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PipelineResourceInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}/createRun")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CreateRunResponseInner>> createRun(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="referencePipelineRunId") String var7, @QueryParam(value="isRecovery") Boolean var8, @QueryParam(value="startActivityName") String var9, @QueryParam(value="startFromFailure") Boolean var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}/createRun")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CreateRunResponseInner> createRunSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="pipelineName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="referencePipelineRunId") String var7, @QueryParam(value="isRecovery") Boolean var8, @QueryParam(value="startActivityName") String var9, @QueryParam(value="startFromFailure") Boolean var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PipelineListResponse>> listByFactoryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PipelineListResponse> listByFactoryNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

