/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureFolder;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureResource;
import com.azure.resourcemanager.datafactory.models.MapperPolicy;
import com.azure.resourcemanager.datafactory.models.MapperSourceConnectionsInfo;
import com.azure.resourcemanager.datafactory.models.MapperTargetConnectionsInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ChangeDataCaptureResourceImpl
implements ChangeDataCaptureResource,
ChangeDataCaptureResource.Definition,
ChangeDataCaptureResource.Update {
    private ChangeDataCaptureResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String changeDataCaptureName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Map<String, Object> additionalProperties() {
        Map<String, Object> inner = this.innerModel().additionalProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ChangeDataCaptureFolder folder() {
        return this.innerModel().folder();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public List<MapperSourceConnectionsInfo> sourceConnectionsInfo() {
        List<MapperSourceConnectionsInfo> inner = this.innerModel().sourceConnectionsInfo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<MapperTargetConnectionsInfo> targetConnectionsInfo() {
        List<MapperTargetConnectionsInfo> inner = this.innerModel().targetConnectionsInfo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public MapperPolicy policy() {
        return this.innerModel().policy();
    }

    @Override
    public Boolean allowVNetOverride() {
        return this.innerModel().allowVNetOverride();
    }

    @Override
    public String status() {
        return this.innerModel().status();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ChangeDataCaptureResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public ChangeDataCaptureResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public ChangeDataCaptureResource create() {
        this.innerObject = (ChangeDataCaptureResourceInner)((Object)this.serviceManager.serviceClient().getChangeDataCaptures().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ChangeDataCaptureResource create(Context context) {
        this.innerObject = (ChangeDataCaptureResourceInner)((Object)this.serviceManager.serviceClient().getChangeDataCaptures().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    ChangeDataCaptureResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new ChangeDataCaptureResourceInner();
        this.serviceManager = serviceManager;
        this.changeDataCaptureName = name;
        this.createIfMatch = null;
    }

    @Override
    public ChangeDataCaptureResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ChangeDataCaptureResource apply() {
        this.innerObject = (ChangeDataCaptureResourceInner)((Object)this.serviceManager.serviceClient().getChangeDataCaptures().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ChangeDataCaptureResource apply(Context context) {
        this.innerObject = (ChangeDataCaptureResourceInner)((Object)this.serviceManager.serviceClient().getChangeDataCaptures().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    ChangeDataCaptureResourceImpl(ChangeDataCaptureResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.changeDataCaptureName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "adfcdcs");
    }

    @Override
    public ChangeDataCaptureResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (ChangeDataCaptureResourceInner)((Object)this.serviceManager.serviceClient().getChangeDataCaptures().getWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ChangeDataCaptureResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (ChangeDataCaptureResourceInner)((Object)this.serviceManager.serviceClient().getChangeDataCaptures().getWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public Response<Void> startWithResponse(Context context) {
        return this.serviceManager.changeDataCaptures().startWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, context);
    }

    @Override
    public void start() {
        this.serviceManager.changeDataCaptures().start(this.resourceGroupName, this.factoryName, this.changeDataCaptureName);
    }

    @Override
    public Response<Void> stopWithResponse(Context context) {
        return this.serviceManager.changeDataCaptures().stopWithResponse(this.resourceGroupName, this.factoryName, this.changeDataCaptureName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.changeDataCaptures().stop(this.resourceGroupName, this.factoryName, this.changeDataCaptureName);
    }

    @Override
    public ChangeDataCaptureResourceImpl withSourceConnectionsInfo(List<MapperSourceConnectionsInfo> sourceConnectionsInfo) {
        this.innerModel().withSourceConnectionsInfo(sourceConnectionsInfo);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withTargetConnectionsInfo(List<MapperTargetConnectionsInfo> targetConnectionsInfo) {
        this.innerModel().withTargetConnectionsInfo(targetConnectionsInfo);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withPolicy(MapperPolicy policy) {
        this.innerModel().withPolicy(policy);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.innerModel().withAdditionalProperties(additionalProperties);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withFolder(ChangeDataCaptureFolder folder) {
        this.innerModel().withFolder(folder);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withAllowVNetOverride(Boolean allowVNetOverride) {
        this.innerModel().withAllowVNetOverride(allowVNetOverride);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withStatus(String status) {
        this.innerModel().withStatus(status);
        return this;
    }

    @Override
    public ChangeDataCaptureResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

