/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class VerticaLinkedServiceTypeProperties
implements JsonSerializable<VerticaLinkedServiceTypeProperties> {
    private Object connectionString;
    private Object server;
    private Object port;
    private Object uid;
    private Object database;
    private AzureKeyVaultSecretReference pwd;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public VerticaLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public VerticaLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public VerticaLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object uid() {
        return this.uid;
    }

    public VerticaLinkedServiceTypeProperties withUid(Object uid) {
        this.uid = uid;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public VerticaLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public AzureKeyVaultSecretReference pwd() {
        return this.pwd;
    }

    public VerticaLinkedServiceTypeProperties withPwd(AzureKeyVaultSecretReference pwd) {
        this.pwd = pwd;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public VerticaLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.pwd() != null) {
            this.pwd().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        if (this.server != null) {
            jsonWriter.writeUntypedField("server", this.server);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.uid != null) {
            jsonWriter.writeUntypedField("uid", this.uid);
        }
        if (this.database != null) {
            jsonWriter.writeUntypedField("database", this.database);
        }
        jsonWriter.writeJsonField("pwd", (JsonSerializable)this.pwd);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static VerticaLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VerticaLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            VerticaLinkedServiceTypeProperties deserializedVerticaLinkedServiceTypeProperties = new VerticaLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("uid".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.uid = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("pwd".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.pwd = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedVerticaLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVerticaLinkedServiceTypeProperties;
        });
    }
}

