/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class TwilioLinkedServiceTypeProperties
implements JsonSerializable<TwilioLinkedServiceTypeProperties> {
    private Object username;
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(TwilioLinkedServiceTypeProperties.class);

    public Object username() {
        return this.username;
    }

    public TwilioLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public TwilioLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model TwilioLinkedServiceTypeProperties"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model TwilioLinkedServiceTypeProperties"));
        }
        this.password().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        return jsonWriter.writeEndObject();
    }

    public static TwilioLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TwilioLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            TwilioLinkedServiceTypeProperties deserializedTwilioLinkedServiceTypeProperties = new TwilioLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedTwilioLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedTwilioLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTwilioLinkedServiceTypeProperties;
        });
    }
}

