/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Trigger;
import java.io.IOException;

public final class TriggerResourceInner
extends SubResource {
    private Trigger properties;
    private String name;
    private String type;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(TriggerResourceInner.class);

    public Trigger properties() {
        return this.properties;
    }

    public TriggerResourceInner withProperties(Trigger properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public TriggerResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model TriggerResourceInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static TriggerResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerResourceInner)((Object)jsonReader.readObject(reader -> {
            TriggerResourceInner deserializedTriggerResourceInner = new TriggerResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTriggerResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTriggerResourceInner.properties = Trigger.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTriggerResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTriggerResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedTriggerResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerResourceInner;
        }));
    }
}

