/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.TeamDeskAuthenticationType;
import java.io.IOException;

public final class TeamDeskLinkedServiceTypeProperties
implements JsonSerializable<TeamDeskLinkedServiceTypeProperties> {
    private TeamDeskAuthenticationType authenticationType;
    private Object url;
    private Object username;
    private SecretBase password;
    private SecretBase apiToken;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(TeamDeskLinkedServiceTypeProperties.class);

    public TeamDeskAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public TeamDeskLinkedServiceTypeProperties withAuthenticationType(TeamDeskAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object url() {
        return this.url;
    }

    public TeamDeskLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public TeamDeskLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public TeamDeskLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public SecretBase apiToken() {
        return this.apiToken;
    }

    public TeamDeskLinkedServiceTypeProperties withApiToken(SecretBase apiToken) {
        this.apiToken = apiToken;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public TeamDeskLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model TeamDeskLinkedServiceTypeProperties"));
        }
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model TeamDeskLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.apiToken() != null) {
            this.apiToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("url", this.url);
        if (this.username != null) {
            jsonWriter.writeUntypedField("userName", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeJsonField("apiToken", (JsonSerializable)this.apiToken);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static TeamDeskLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TeamDeskLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            TeamDeskLinkedServiceTypeProperties deserializedTeamDeskLinkedServiceTypeProperties = new TeamDeskLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authenticationType".equals(fieldName)) {
                    deserializedTeamDeskLinkedServiceTypeProperties.authenticationType = TeamDeskAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedTeamDeskLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedTeamDeskLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedTeamDeskLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("apiToken".equals(fieldName)) {
                    deserializedTeamDeskLinkedServiceTypeProperties.apiToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedTeamDeskLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTeamDeskLinkedServiceTypeProperties;
        });
    }
}

