/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SmartsheetLinkedServiceTypeProperties
implements JsonSerializable<SmartsheetLinkedServiceTypeProperties> {
    private SecretBase apiToken;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SmartsheetLinkedServiceTypeProperties.class);

    public SecretBase apiToken() {
        return this.apiToken;
    }

    public SmartsheetLinkedServiceTypeProperties withApiToken(SecretBase apiToken) {
        this.apiToken = apiToken;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SmartsheetLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.apiToken() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiToken in model SmartsheetLinkedServiceTypeProperties"));
        }
        this.apiToken().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("apiToken", (JsonSerializable)this.apiToken);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SmartsheetLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SmartsheetLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SmartsheetLinkedServiceTypeProperties deserializedSmartsheetLinkedServiceTypeProperties = new SmartsheetLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("apiToken".equals(fieldName)) {
                    deserializedSmartsheetLinkedServiceTypeProperties.apiToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSmartsheetLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSmartsheetLinkedServiceTypeProperties;
        });
    }
}

