/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeNodeInner;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAutoUpdate;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeInternalChannelEncryptionMode;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntime;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SelfHostedIntegrationRuntimeStatusTypeProperties
implements JsonSerializable<SelfHostedIntegrationRuntimeStatusTypeProperties> {
    private OffsetDateTime createTime;
    private String taskQueueId;
    private IntegrationRuntimeInternalChannelEncryptionMode internalChannelEncryption;
    private String version;
    private List<SelfHostedIntegrationRuntimeNodeInner> nodes;
    private OffsetDateTime scheduledUpdateDate;
    private String updateDelayOffset;
    private String localTimeZoneOffset;
    private Map<String, String> capabilities;
    private List<String> serviceUrls;
    private IntegrationRuntimeAutoUpdate autoUpdate;
    private String versionStatus;
    private List<LinkedIntegrationRuntime> links;
    private String pushedVersion;
    private String latestVersion;
    private OffsetDateTime autoUpdateEta;
    private Boolean selfContainedInteractiveAuthoringEnabled;

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public String taskQueueId() {
        return this.taskQueueId;
    }

    public IntegrationRuntimeInternalChannelEncryptionMode internalChannelEncryption() {
        return this.internalChannelEncryption;
    }

    public String version() {
        return this.version;
    }

    public List<SelfHostedIntegrationRuntimeNodeInner> nodes() {
        return this.nodes;
    }

    public SelfHostedIntegrationRuntimeStatusTypeProperties withNodes(List<SelfHostedIntegrationRuntimeNodeInner> nodes) {
        this.nodes = nodes;
        return this;
    }

    public OffsetDateTime scheduledUpdateDate() {
        return this.scheduledUpdateDate;
    }

    public String updateDelayOffset() {
        return this.updateDelayOffset;
    }

    public String localTimeZoneOffset() {
        return this.localTimeZoneOffset;
    }

    public Map<String, String> capabilities() {
        return this.capabilities;
    }

    public List<String> serviceUrls() {
        return this.serviceUrls;
    }

    public IntegrationRuntimeAutoUpdate autoUpdate() {
        return this.autoUpdate;
    }

    public String versionStatus() {
        return this.versionStatus;
    }

    public List<LinkedIntegrationRuntime> links() {
        return this.links;
    }

    public SelfHostedIntegrationRuntimeStatusTypeProperties withLinks(List<LinkedIntegrationRuntime> links) {
        this.links = links;
        return this;
    }

    public String pushedVersion() {
        return this.pushedVersion;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public OffsetDateTime autoUpdateEta() {
        return this.autoUpdateEta;
    }

    public Boolean selfContainedInteractiveAuthoringEnabled() {
        return this.selfContainedInteractiveAuthoringEnabled;
    }

    public void validate() {
        if (this.nodes() != null) {
            this.nodes().forEach(e -> e.validate());
        }
        if (this.links() != null) {
            this.links().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("nodes", this.nodes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("links", this.links, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SelfHostedIntegrationRuntimeStatusTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SelfHostedIntegrationRuntimeStatusTypeProperties)jsonReader.readObject(reader -> {
            SelfHostedIntegrationRuntimeStatusTypeProperties deserializedSelfHostedIntegrationRuntimeStatusTypeProperties = new SelfHostedIntegrationRuntimeStatusTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createTime".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.createTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskQueueId".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.taskQueueId = reader.getString();
                    continue;
                }
                if ("internalChannelEncryption".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.internalChannelEncryption = IntegrationRuntimeInternalChannelEncryptionMode.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.version = reader.getString();
                    continue;
                }
                if ("nodes".equals(fieldName)) {
                    List nodes;
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.nodes = nodes = reader.readArray(reader1 -> SelfHostedIntegrationRuntimeNodeInner.fromJson(reader1));
                    continue;
                }
                if ("scheduledUpdateDate".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.scheduledUpdateDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updateDelayOffset".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.updateDelayOffset = reader.getString();
                    continue;
                }
                if ("localTimeZoneOffset".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.localTimeZoneOffset = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    Map capabilities;
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.capabilities = capabilities = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("serviceUrls".equals(fieldName)) {
                    List serviceUrls;
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.serviceUrls = serviceUrls = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("autoUpdate".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.autoUpdate = IntegrationRuntimeAutoUpdate.fromString(reader.getString());
                    continue;
                }
                if ("versionStatus".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.versionStatus = reader.getString();
                    continue;
                }
                if ("links".equals(fieldName)) {
                    List links;
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.links = links = reader.readArray(reader1 -> LinkedIntegrationRuntime.fromJson(reader1));
                    continue;
                }
                if ("pushedVersion".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.pushedVersion = reader.getString();
                    continue;
                }
                if ("latestVersion".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.latestVersion = reader.getString();
                    continue;
                }
                if ("autoUpdateETA".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.autoUpdateEta = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("selfContainedInteractiveAuthoringEnabled".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatusTypeProperties.selfContainedInteractiveAuthoringEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSelfHostedIntegrationRuntimeStatusTypeProperties;
        });
    }
}

