/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SapBWLinkedServiceTypeProperties
implements JsonSerializable<SapBWLinkedServiceTypeProperties> {
    private Object server;
    private Object systemNumber;
    private Object clientId;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SapBWLinkedServiceTypeProperties.class);

    public Object server() {
        return this.server;
    }

    public SapBWLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object systemNumber() {
        return this.systemNumber;
    }

    public SapBWLinkedServiceTypeProperties withSystemNumber(Object systemNumber) {
        this.systemNumber = systemNumber;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public SapBWLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SapBWLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SapBWLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SapBWLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model SapBWLinkedServiceTypeProperties"));
        }
        if (this.systemNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property systemNumber in model SapBWLinkedServiceTypeProperties"));
        }
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model SapBWLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeUntypedField("systemNumber", this.systemNumber);
        jsonWriter.writeUntypedField("clientId", this.clientId);
        if (this.username != null) {
            jsonWriter.writeUntypedField("userName", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SapBWLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapBWLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SapBWLinkedServiceTypeProperties deserializedSapBWLinkedServiceTypeProperties = new SapBWLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedSapBWLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("systemNumber".equals(fieldName)) {
                    deserializedSapBWLinkedServiceTypeProperties.systemNumber = reader.readUntyped();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedSapBWLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSapBWLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSapBWLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSapBWLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapBWLinkedServiceTypeProperties;
        });
    }
}

