/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PrestoAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class PrestoLinkedServiceTypeProperties
implements JsonSerializable<PrestoLinkedServiceTypeProperties> {
    private Object host;
    private Object serverVersion;
    private Object catalog;
    private Object port;
    private PrestoAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostnameCNMismatch;
    private Object allowSelfSignedServerCert;
    private Object timeZoneId;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(PrestoLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public PrestoLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object serverVersion() {
        return this.serverVersion;
    }

    public PrestoLinkedServiceTypeProperties withServerVersion(Object serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public Object catalog() {
        return this.catalog;
    }

    public PrestoLinkedServiceTypeProperties withCatalog(Object catalog) {
        this.catalog = catalog;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public PrestoLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public PrestoAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public PrestoLinkedServiceTypeProperties withAuthenticationType(PrestoAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public PrestoLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public PrestoLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public PrestoLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public PrestoLinkedServiceTypeProperties withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public PrestoLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public PrestoLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    public PrestoLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public PrestoLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public Object timeZoneId() {
        return this.timeZoneId;
    }

    public PrestoLinkedServiceTypeProperties withTimeZoneId(Object timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public PrestoLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model PrestoLinkedServiceTypeProperties"));
        }
        if (this.catalog() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property catalog in model PrestoLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model PrestoLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("catalog", this.catalog);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.serverVersion != null) {
            jsonWriter.writeUntypedField("serverVersion", this.serverVersion);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.enableServerCertificateValidation != null) {
            jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
        }
        if (this.trustedCertPath != null) {
            jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        if (this.allowHostnameCNMismatch != null) {
            jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostnameCNMismatch);
        }
        if (this.allowSelfSignedServerCert != null) {
            jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        }
        if (this.timeZoneId != null) {
            jsonWriter.writeUntypedField("timeZoneID", this.timeZoneId);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static PrestoLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrestoLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            PrestoLinkedServiceTypeProperties deserializedPrestoLinkedServiceTypeProperties = new PrestoLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("catalog".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.catalog = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.authenticationType = PrestoAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("serverVersion".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.serverVersion = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("enableServerCertificateValidation".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.enableServerCertificateValidation = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("allowHostNameCNMismatch".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.allowHostnameCNMismatch = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("timeZoneID".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.timeZoneId = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedPrestoLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrestoLinkedServiceTypeProperties;
        });
    }
}

