/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PhoenixAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class PhoenixLinkedServiceTypeProperties
implements JsonSerializable<PhoenixLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private Object httpPath;
    private PhoenixAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object enableSsl;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostnameCNMismatch;
    private Object allowSelfSignedServerCert;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(PhoenixLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public PhoenixLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public PhoenixLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object httpPath() {
        return this.httpPath;
    }

    public PhoenixLinkedServiceTypeProperties withHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public PhoenixAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public PhoenixLinkedServiceTypeProperties withAuthenticationType(PhoenixAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public PhoenixLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public PhoenixLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public PhoenixLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public PhoenixLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public PhoenixLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    public PhoenixLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public PhoenixLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public PhoenixLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model PhoenixLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model PhoenixLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.httpPath != null) {
            jsonWriter.writeUntypedField("httpPath", this.httpPath);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.trustedCertPath != null) {
            jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        if (this.allowHostnameCNMismatch != null) {
            jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostnameCNMismatch);
        }
        if (this.allowSelfSignedServerCert != null) {
            jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static PhoenixLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PhoenixLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            PhoenixLinkedServiceTypeProperties deserializedPhoenixLinkedServiceTypeProperties = new PhoenixLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.authenticationType = PhoenixAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("httpPath".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.httpPath = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("allowHostNameCNMismatch".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.allowHostnameCNMismatch = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedPhoenixLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPhoenixLinkedServiceTypeProperties;
        });
    }
}

