/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class OracleServiceCloudLinkedServiceTypeProperties
implements JsonSerializable<OracleServiceCloudLinkedServiceTypeProperties> {
    private Object host;
    private Object username;
    private SecretBase password;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(OracleServiceCloudLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public OracleServiceCloudLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model OracleServiceCloudLinkedServiceTypeProperties"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model OracleServiceCloudLinkedServiceTypeProperties"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model OracleServiceCloudLinkedServiceTypeProperties"));
        }
        this.password().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.useEncryptedEndpoints != null) {
            jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        }
        if (this.useHostVerification != null) {
            jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        }
        if (this.usePeerVerification != null) {
            jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static OracleServiceCloudLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OracleServiceCloudLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            OracleServiceCloudLinkedServiceTypeProperties deserializedOracleServiceCloudLinkedServiceTypeProperties = new OracleServiceCloudLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedOracleServiceCloudLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOracleServiceCloudLinkedServiceTypeProperties;
        });
    }
}

