/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ODataAadServicePrincipalCredentialType;
import com.azure.resourcemanager.datafactory.models.ODataAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class ODataLinkedServiceTypeProperties
implements JsonSerializable<ODataLinkedServiceTypeProperties> {
    private Object url;
    private ODataAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object authHeaders;
    private Object tenant;
    private Object servicePrincipalId;
    private Object azureCloudType;
    private Object aadResourceId;
    private ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType;
    private SecretBase servicePrincipalKey;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(ODataLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public ODataLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public ODataAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ODataLinkedServiceTypeProperties withAuthenticationType(ODataAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public ODataLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public ODataLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object authHeaders() {
        return this.authHeaders;
    }

    public ODataLinkedServiceTypeProperties withAuthHeaders(Object authHeaders) {
        this.authHeaders = authHeaders;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public ODataLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public ODataLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public ODataLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object aadResourceId() {
        return this.aadResourceId;
    }

    public ODataLinkedServiceTypeProperties withAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    public ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType() {
        return this.aadServicePrincipalCredentialType;
    }

    public ODataLinkedServiceTypeProperties withAadServicePrincipalCredentialType(ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType) {
        this.aadServicePrincipalCredentialType = aadServicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public ODataLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public ODataLinkedServiceTypeProperties withServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public ODataLinkedServiceTypeProperties withServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public ODataLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model ODataLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.servicePrincipalEmbeddedCert() != null) {
            this.servicePrincipalEmbeddedCert().validate();
        }
        if (this.servicePrincipalEmbeddedCertPassword() != null) {
            this.servicePrincipalEmbeddedCertPassword().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("userName", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.authHeaders != null) {
            jsonWriter.writeUntypedField("authHeaders", this.authHeaders);
        }
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        if (this.aadResourceId != null) {
            jsonWriter.writeUntypedField("aadResourceId", this.aadResourceId);
        }
        jsonWriter.writeStringField("aadServicePrincipalCredentialType", this.aadServicePrincipalCredentialType == null ? null : this.aadServicePrincipalCredentialType.toString());
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
        jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static ODataLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ODataLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            ODataLinkedServiceTypeProperties deserializedODataLinkedServiceTypeProperties = new ODataLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.authenticationType = ODataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authHeaders".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.authHeaders = reader.readUntyped();
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("aadResourceId".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.aadResourceId = reader.readUntyped();
                    continue;
                }
                if ("aadServicePrincipalCredentialType".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.aadServicePrincipalCredentialType = ODataAadServicePrincipalCredentialType.fromString(reader.getString());
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedODataLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedODataLinkedServiceTypeProperties;
        });
    }
}

