/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ImpalaAuthenticationType;
import com.azure.resourcemanager.datafactory.models.ImpalaThriftTransportProtocol;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class ImpalaLinkedServiceTypeProperties
implements JsonSerializable<ImpalaLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private ImpalaAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private ImpalaThriftTransportProtocol thriftTransportProtocol;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostnameCNMismatch;
    private Object allowSelfSignedServerCert;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(ImpalaLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public ImpalaLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public ImpalaLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public ImpalaAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ImpalaLinkedServiceTypeProperties withAuthenticationType(ImpalaAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public ImpalaLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public ImpalaLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public ImpalaThriftTransportProtocol thriftTransportProtocol() {
        return this.thriftTransportProtocol;
    }

    public ImpalaLinkedServiceTypeProperties withThriftTransportProtocol(ImpalaThriftTransportProtocol thriftTransportProtocol) {
        this.thriftTransportProtocol = thriftTransportProtocol;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public ImpalaLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public ImpalaLinkedServiceTypeProperties withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public ImpalaLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public ImpalaLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    public ImpalaLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public ImpalaLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public ImpalaLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model ImpalaLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model ImpalaLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("thriftTransportProtocol", this.thriftTransportProtocol == null ? null : this.thriftTransportProtocol.toString());
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.enableServerCertificateValidation != null) {
            jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
        }
        if (this.trustedCertPath != null) {
            jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        }
        if (this.useSystemTrustStore != null) {
            jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
        }
        if (this.allowHostnameCNMismatch != null) {
            jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostnameCNMismatch);
        }
        if (this.allowSelfSignedServerCert != null) {
            jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static ImpalaLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ImpalaLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            ImpalaLinkedServiceTypeProperties deserializedImpalaLinkedServiceTypeProperties = new ImpalaLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.authenticationType = ImpalaAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("thriftTransportProtocol".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.thriftTransportProtocol = ImpalaThriftTransportProtocol.fromString(reader.getString());
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("enableServerCertificateValidation".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.enableServerCertificateValidation = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("useSystemTrustStore".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.useSystemTrustStore = reader.readUntyped();
                    continue;
                }
                if ("allowHostNameCNMismatch".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.allowHostnameCNMismatch = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedImpalaLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImpalaLinkedServiceTypeProperties;
        });
    }
}

