/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class HubspotLinkedServiceTypeProperties
implements JsonSerializable<HubspotLinkedServiceTypeProperties> {
    private Object clientId;
    private SecretBase clientSecret;
    private SecretBase accessToken;
    private SecretBase refreshToken;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(HubspotLinkedServiceTypeProperties.class);

    public Object clientId() {
        return this.clientId;
    }

    public HubspotLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public HubspotLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public SecretBase accessToken() {
        return this.accessToken;
    }

    public HubspotLinkedServiceTypeProperties withAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public SecretBase refreshToken() {
        return this.refreshToken;
    }

    public HubspotLinkedServiceTypeProperties withRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public HubspotLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public HubspotLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public HubspotLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HubspotLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model HubspotLinkedServiceTypeProperties"));
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
        if (this.accessToken() != null) {
            this.accessToken().validate();
        }
        if (this.refreshToken() != null) {
            this.refreshToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
        jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
        if (this.useEncryptedEndpoints != null) {
            jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        }
        if (this.useHostVerification != null) {
            jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        }
        if (this.usePeerVerification != null) {
            jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static HubspotLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HubspotLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HubspotLinkedServiceTypeProperties deserializedHubspotLinkedServiceTypeProperties = new HubspotLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientId".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.accessToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.refreshToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHubspotLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubspotLinkedServiceTypeProperties;
        });
    }
}

