/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HDInsightPigActivityTypeProperties
implements JsonSerializable<HDInsightPigActivityTypeProperties> {
    private List<LinkedServiceReference> storageLinkedServices;
    private Object arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object scriptPath;
    private LinkedServiceReference scriptLinkedService;
    private Map<String, Object> defines;

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightPigActivityTypeProperties withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public Object arguments() {
        return this.arguments;
    }

    public HDInsightPigActivityTypeProperties withArguments(Object arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightPigActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object scriptPath() {
        return this.scriptPath;
    }

    public HDInsightPigActivityTypeProperties withScriptPath(Object scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    public LinkedServiceReference scriptLinkedService() {
        return this.scriptLinkedService;
    }

    public HDInsightPigActivityTypeProperties withScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        this.scriptLinkedService = scriptLinkedService;
        return this;
    }

    public Map<String, Object> defines() {
        return this.defines;
    }

    public HDInsightPigActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public void validate() {
        if (this.storageLinkedServices() != null) {
            this.storageLinkedServices().forEach(e -> e.validate());
        }
        if (this.scriptLinkedService() != null) {
            this.scriptLinkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.arguments != null) {
            jsonWriter.writeUntypedField("arguments", this.arguments);
        }
        jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
        if (this.scriptPath != null) {
            jsonWriter.writeUntypedField("scriptPath", this.scriptPath);
        }
        jsonWriter.writeJsonField("scriptLinkedService", (JsonSerializable)this.scriptLinkedService);
        jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static HDInsightPigActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightPigActivityTypeProperties)jsonReader.readObject(reader -> {
            HDInsightPigActivityTypeProperties deserializedHDInsightPigActivityTypeProperties = new HDInsightPigActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageLinkedServices".equals(fieldName)) {
                    List storageLinkedServices;
                    deserializedHDInsightPigActivityTypeProperties.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    deserializedHDInsightPigActivityTypeProperties.arguments = reader.readUntyped();
                    continue;
                }
                if ("getDebugInfo".equals(fieldName)) {
                    deserializedHDInsightPigActivityTypeProperties.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                    continue;
                }
                if ("scriptPath".equals(fieldName)) {
                    deserializedHDInsightPigActivityTypeProperties.scriptPath = reader.readUntyped();
                    continue;
                }
                if ("scriptLinkedService".equals(fieldName)) {
                    deserializedHDInsightPigActivityTypeProperties.scriptLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("defines".equals(fieldName)) {
                    Map defines;
                    deserializedHDInsightPigActivityTypeProperties.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightPigActivityTypeProperties;
        });
    }
}

