/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HDInsightMapReduceActivityTypeProperties
implements JsonSerializable<HDInsightMapReduceActivityTypeProperties> {
    private List<LinkedServiceReference> storageLinkedServices;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object className;
    private Object jarFilePath;
    private LinkedServiceReference jarLinkedService;
    private List<Object> jarLibs;
    private Map<String, Object> defines;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightMapReduceActivityTypeProperties.class);

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightMapReduceActivityTypeProperties withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public HDInsightMapReduceActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightMapReduceActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object className() {
        return this.className;
    }

    public HDInsightMapReduceActivityTypeProperties withClassName(Object className) {
        this.className = className;
        return this;
    }

    public Object jarFilePath() {
        return this.jarFilePath;
    }

    public HDInsightMapReduceActivityTypeProperties withJarFilePath(Object jarFilePath) {
        this.jarFilePath = jarFilePath;
        return this;
    }

    public LinkedServiceReference jarLinkedService() {
        return this.jarLinkedService;
    }

    public HDInsightMapReduceActivityTypeProperties withJarLinkedService(LinkedServiceReference jarLinkedService) {
        this.jarLinkedService = jarLinkedService;
        return this;
    }

    public List<Object> jarLibs() {
        return this.jarLibs;
    }

    public HDInsightMapReduceActivityTypeProperties withJarLibs(List<Object> jarLibs) {
        this.jarLibs = jarLibs;
        return this;
    }

    public Map<String, Object> defines() {
        return this.defines;
    }

    public HDInsightMapReduceActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public void validate() {
        if (this.storageLinkedServices() != null) {
            this.storageLinkedServices().forEach(e -> e.validate());
        }
        if (this.className() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property className in model HDInsightMapReduceActivityTypeProperties"));
        }
        if (this.jarFilePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property jarFilePath in model HDInsightMapReduceActivityTypeProperties"));
        }
        if (this.jarLinkedService() != null) {
            this.jarLinkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("className", this.className);
        jsonWriter.writeUntypedField("jarFilePath", this.jarFilePath);
        jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
        jsonWriter.writeJsonField("jarLinkedService", (JsonSerializable)this.jarLinkedService);
        jsonWriter.writeArrayField("jarLibs", this.jarLibs, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static HDInsightMapReduceActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightMapReduceActivityTypeProperties)jsonReader.readObject(reader -> {
            HDInsightMapReduceActivityTypeProperties deserializedHDInsightMapReduceActivityTypeProperties = new HDInsightMapReduceActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("className".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivityTypeProperties.className = reader.readUntyped();
                    continue;
                }
                if ("jarFilePath".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivityTypeProperties.jarFilePath = reader.readUntyped();
                    continue;
                }
                if ("storageLinkedServices".equals(fieldName)) {
                    List storageLinkedServices;
                    deserializedHDInsightMapReduceActivityTypeProperties.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedHDInsightMapReduceActivityTypeProperties.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("getDebugInfo".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivityTypeProperties.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                    continue;
                }
                if ("jarLinkedService".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivityTypeProperties.jarLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("jarLibs".equals(fieldName)) {
                    List jarLibs;
                    deserializedHDInsightMapReduceActivityTypeProperties.jarLibs = jarLibs = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("defines".equals(fieldName)) {
                    Map defines;
                    deserializedHDInsightMapReduceActivityTypeProperties.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightMapReduceActivityTypeProperties;
        });
    }
}

