/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.GoogleBigQueryV2AuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class GoogleBigQueryV2LinkedServiceTypeProperties
implements JsonSerializable<GoogleBigQueryV2LinkedServiceTypeProperties> {
    private Object projectId;
    private GoogleBigQueryV2AuthenticationType authenticationType;
    private Object clientId;
    private SecretBase clientSecret;
    private SecretBase refreshToken;
    private SecretBase keyFileContent;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(GoogleBigQueryV2LinkedServiceTypeProperties.class);

    public Object projectId() {
        return this.projectId;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withProjectId(Object projectId) {
        this.projectId = projectId;
        return this;
    }

    public GoogleBigQueryV2AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withAuthenticationType(GoogleBigQueryV2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public SecretBase refreshToken() {
        return this.refreshToken;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public SecretBase keyFileContent() {
        return this.keyFileContent;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withKeyFileContent(SecretBase keyFileContent) {
        this.keyFileContent = keyFileContent;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleBigQueryV2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.projectId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property projectId in model GoogleBigQueryV2LinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model GoogleBigQueryV2LinkedServiceTypeProperties"));
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
        if (this.refreshToken() != null) {
            this.refreshToken().validate();
        }
        if (this.keyFileContent() != null) {
            this.keyFileContent().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("projectId", this.projectId);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
        jsonWriter.writeJsonField("keyFileContent", (JsonSerializable)this.keyFileContent);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static GoogleBigQueryV2LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleBigQueryV2LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            GoogleBigQueryV2LinkedServiceTypeProperties deserializedGoogleBigQueryV2LinkedServiceTypeProperties = new GoogleBigQueryV2LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("projectId".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.projectId = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.authenticationType = GoogleBigQueryV2AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.refreshToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("keyFileContent".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.keyFileContent = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGoogleBigQueryV2LinkedServiceTypeProperties;
        });
    }
}

